<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job     job         =   (Job) process.getAttribute("Job"); 
    int     shortlisted =   job.getNoOfCandidatesShortlisted();
    String  editJobPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.EDIT_JOB);
    String  sharePage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.CREATED_JOB);
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, (shortlisted > 0 ? WebUtils.APPLICANTS_SHORTLIST : WebUtils.VIEW_APPLICANTS));
%>

<oneit:dynIncluded>

    <div class="officer-box">
        <div class="officer-name">
            <div class="chief-officer">
                <%
                    if(job.getClient() != null)
                    {
                        int logoWidth   =   27;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(job.getClient().getClientLogo()), "KEEP", new ScaleWithin (logoWidth, 0)) %>" />
                <%
                    }
                %>
                <oneit:button   value=" "   name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                .toMap() %>">
                    <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                </oneit:button>
            </div>
            <div class="off-name">
                <span class="austr-post">
                    <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                </span> by <oneit:toString   value="<%= job.getCompanyUser() %>"  mode="EscapeHTML"  nullValue=""/><span class="ex-management">&bull;&nbsp;
                    <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
                </span>
            </div>
        </div>
        <div class="applicant-right-status">
            <span class="light-calendar">
                <%
                    if(job.getJobStatus() == JobStatus.OPEN)
                    {
                        int daysToClose =   job.getNoOfDaystoClosed();
                %>
                        <span class="number">
                            <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                        </span>
                        <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                <%
                    }
                    else
                    {
                %>
                        <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                        <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                <%
                    }
                %>
            </span>
            <span class="job-status-appli">
                <span class="<%= job.getJobStatus().getName().toLowerCase() + "-status-icon" %>"></span>
                <oneit:toString  value="<%= job.getJobStatusText() %>"    mode="EscapeHTML"/>
            </span>
            
            <span class="edit-btn-dropdown">
                <oneit:button   value="Share"   cssClass="leftbtn"  name="gotoPage" skin="link"
                                disabled="<%= job.getJobStatus() != JobStatus.OPEN ? "true" : "false" %>"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", sharePage + "&JobID=" + job.getObjectID())
                                                                .mapEntry("cancelProcess", true)
                                                                .toMap() %>"/>
                <oneit:button   value=" " cssClass="rightbtn"  name="gotoPage" skin="link"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", editJobPage + "&JobID=" + job.getObjectID())
                                                                .mapEntry("cancelProcess", true)
                                                                .toMap() %>">
                    EDIT
                    <span><img src="images/edit-dropdown-arrow.svg" /></span>
                </oneit:button>
            </span>

        </div>
    </div>
</oneit:dynIncluded>