<%@page import="performa.orm.types.StageType"%>
<%@page import="performa.orm.WorkFlowStage"%>
<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job                     job             =   (Job) process.getAttribute("Job");
    WorkFlowStage           workFlowStage   =   (WorkFlowStage)  getData(request, "WorkFlowStage");
    StageType               stageType       =   workFlowStage != null ? workFlowStage.getStageType() : null;
    AppView                 appView         =   (AppView) getData(request, "AppView");
    String                  applicantsPage  =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "applications");

    int     noOfIncomplete  =   job.getNoOfCandidatesFor(job.getWorkFlowByStageType(StageType.INCOMPLETE), job.getWorkFlowByStageType(StageType.POST_INGEST)); 
    int     noOfUnsuitable  =   job.getNoOfCandidatesFor(job.getWorkFlowByStageType(StageType.UNSUITABLE)); 
    int     allCandidates   =   job.getNoOfCandidatesApplied(); 
%>
<oneit:dynIncluded>

    <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
    
    <div class="first-part">
        
    <oneit:dynInclude   page="/extensions/adminportal/inc/job_title_bar.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"
                        applicantPage="<%= false %>"
                        applications="<%= applications %>"
                        WorkFlow="<%= workFlowStage %>"   
                        AppView="<%= appView %>"/>
        <div class="int-timeline">
            <ul>
                <li class="<%= "incomplete "  + (noOfIncomplete > 0 ? "has-applicant" : "no-applicant") %> <%= stageType == StageType.INCOMPLETE || stageType == StageType.POST_INGEST ? "active" : "inactive" %>">
                    <oneit:button   id="unsuitableBtn"   value=" "   name="gotoPage" skin="link" disabled="<%= noOfIncomplete > 0 ? "false" : "true" %>"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("WorkFlowStage", job.getWorkFlowByStageType(StageType.INCOMPLETE)).toMap())
                                                                    .toMap() %>">
                        <span>
                            <oneit:toString value="<%= noOfIncomplete %>"   mode="Integer" />
                        </span>
                        <div class="app-b-title">
                        <%= job.getWorkFlowStageBySortOrder(1) %>
                        </div>
                    </oneit:button>
                </li>
                <li class="<%= allCandidates > 0 ? "has-applicant" : "" %> <%= (workFlowStage == null) ? "active" : "inactive" %>">
                    <oneit:button   value=" "   name="gotoPage" skin="link" disabled="<%= allCandidates > 0 ? "false" : "true" %>"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("WorkFlowStage", null).toMap())
                                                                    .toMap() %>">
                        <span>
                            <oneit:toString value="<%= allCandidates %>"   mode="Integer" />
                        </span>
                        <div class="app-b-title">All Applicants</div>
                    </oneit:button>
                </li>
            <%
                for (WorkFlowStage workflow : job.getSortedMiddleStages())
                {
                    int noOfCandidates  =   job.getNoOfCandidatesFor(workflow);
            %>
                    <li class="<%= noOfCandidates > 0 ? "has-applicant" : "" %> <%= workflow.equals(workFlowStage) ? "active" : "inactive" %>">
                        <oneit:button   value=" "   name="gotoPage" skin="link" disabled="<%= noOfCandidates > 0 ? "false" : "true" %>"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("WorkFlowStage", workflow).toMap())
                                                                        .toMap() %>">
                            <span>
                                <oneit:toString value="<%= noOfCandidates %>"   mode="Integer" />
                            </span>
                            <div class="app-b-title">
                            <%= workflow.getName() %>
                            </div>
                        </oneit:button>
                    </li>
            <%
                }
            %>
            </ul>
        </div>      
        <div class="unsutable <%= noOfUnsuitable > 0 ? "has-applicant" : "no-applicant" %> <%= stageType == StageType.UNSUITABLE ? "active" : "inactive" %>">
            <oneit:button   id="unsuitableBtn"   value=" "   name="gotoPage" skin="link" disabled="<%= noOfUnsuitable > 0 ? "false" : "true" %>"
                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicantsPage)
                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("WorkFlowStage", job.getWorkFlowByStageType(StageType.UNSUITABLE)).toMap())
                                                            .toMap() %>">
                <span>
                    <oneit:toString value="<%= noOfUnsuitable %>"   mode="Integer" />
                </span>
                <div class="app-b-title">
                <%= job.getWorkFlowStageBySortOrder(9)%>
                </div>
            </oneit:button>
        </div>      
    </div>
                            
</oneit:dynIncluded>

