
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import oneit.security.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class CandidatePersistenceMgr extends SecUserExtensionPersistenceMgr
{
    private static final LoggingArea CandidatePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "Candidate");

    // Private attributes corresponding to business object data
    private String dummyPhone;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_Phone = DefaultAttributeHelper.INSTANCE;
    



    public CandidatePersistenceMgr ()
    {
        dummyPhone = (String)(HELPER_Phone.initialise (dummyPhone));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}oneit_sec_user_extension.object_id as id, {PREFIX}oneit_sec_user_extension.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}oneit_sec_user_extension.object_CREATED_DATE as CREATED_DATE, {PREFIX}oneit_sec_user_extension.object_TYPE as OBJECT_TYPE, {PREFIX}oneit_sec_user_extension.phone, {PREFIX}oneit_sec_user_extension.test_input_id, {PREFIX}oneit_sec_user_extension.user_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, Candidate.REFERENCE_Candidate);

                if (objectToReturn instanceof Candidate)
                {
                    LogMgr.log (CandidatePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a Candidate");
                }
            }

            PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(id, "oneit_sec_user_extension", PersistentSetStatus.FETCHED);
            
            String  objectType = null;

             // Check for persistent sets already prefetched
            if (false ||
                    !oneit_sec_user_extensionPSet.containsAttrib("OBJECT_TYPE") || !oneit_sec_user_extensionPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !oneit_sec_user_extensionPSet.containsAttrib(Candidate.FIELD_Phone)||
                    !oneit_sec_user_extensionPSet.containsAttrib(Candidate.SINGLEREFERENCE_TestInput)||
                    !oneit_sec_user_extensionPSet.containsAttrib(Candidate.SINGLEREFERENCE_User))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (CandidatePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Polymorphic */
                objectType = (String)(oneit_sec_user_extensionPSet.getAttrib("OBJECT_TYPE"));

                if (context.getReferenceObject (Candidate.REFERENCE_Candidate, objectType) != Candidate.REFERENCE_Candidate)
                {
                    idsToFetch.add (id.longValue());
                }
                else
                {
                    Candidate result = new Candidate ();

                    result.setFromPersistentSets(id, allPSets);
                    context.addRetrievedObject(result);

                    results.add (result);
                }
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}oneit_sec_user_extension " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}oneit_sec_user_extension.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (Candidate.SINGLEREFERENCE_TestInput))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}oneit_sec_user_extension " +
                            "WHERE " + SELECT_JOINS + "test_input_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (Candidate.SINGLEREFERENCE_User))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}oneit_sec_user_extension " +
                            "WHERE " + SELECT_JOINS + "user_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension");
            

            
            if (oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}oneit_sec_user_extension " +
                                                           "SET phone = ?, test_input_id = ? , user_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE oneit_sec_user_extension.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_Phone.getForSQL(dummyPhone, oneit_sec_user_extensionPSet.getAttrib (Candidate.FIELD_Phone))).listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (Candidate.SINGLEREFERENCE_TestInput)))).listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (Candidate.SINGLEREFERENCE_User)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}oneit_sec_user_extension WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "oneit_sec_user_extension", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (CandidatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "oneit_sec_user_extension");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:oneit_sec_user_extension for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (CandidatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                oneit_sec_user_extensionPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (CandidatePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension");
        

        LogMgr.log (CandidatePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}oneit_sec_user_extension " +
                                                       "WHERE oneit_sec_user_extension.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}oneit_sec_user_extension WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "oneit_sec_user_extension");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:oneit_sec_user_extension for row:" + objectID;

                    LogMgr.log (CandidatePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            oneit_sec_user_extensionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, Candidate> results = new LinkedHashMap ();
        
        MultiHashtable<String,ObjectID>   needsRefetch = new MultiHashtable ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (Candidate.REFERENCE_Candidate.getObjectIDSpace (), r.getLong ("id"));
            Candidate resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, Candidate.REFERENCE_Candidate);

                if (cachedElement instanceof Candidate)
                {
                    LogMgr.log (CandidatePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (Candidate)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a Candidate");
                }
            }
            else
            {
                PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                
                    String  objectType = (String)(oneit_sec_user_extensionPSet.getAttrib("OBJECT_TYPE"));

                    if (context.getReferenceObject (Candidate.REFERENCE_Candidate, objectType) != Candidate.REFERENCE_Candidate)
                    {
                        needsRefetch.add (objectType, objectID); // We will fetch these later
                        resultElement = new Candidate ();
                        resultElement.initialiseGhost (objectID);
                    }
                    else
                    {
                

                        resultElement = new Candidate ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
                    }
                
            }

            results.put (objectID, resultElement);
        }

        
        for (String objectType : needsRefetch.keySet())
        {
            BaseBusinessClass       referenceObject = context.getReferenceObject (Candidate.REFERENCE_Candidate, objectType);
            ObjectPersistenceMgr    persistenceMgr = context.getPersistenceMgr (referenceObject);
            ResourceCheckpoint      checkpoint = sqlMgr.getCheckpoint();

            Set<BaseBusinessClass>    objsRefetched = persistenceMgr.fetchByIDs(new HashSet (needsRefetch.getValuesForKey (objectType)), allPSets, context, sqlMgr);

            checkpoint.releaseNewResources();

            for (BaseBusinessClass objRefetched : objsRefetched)
            {
                results.put (objRefetched.getID (), (Candidate)objRefetched);
            }
        }
        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (CandidatePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}oneit_sec_user_extension " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        
        else
        {
            
                BaseBusinessClass[] resultsArray = super.find(searchType, allPSets, criteria, context, sqlMgr);
                Vector              results = new Vector ();
                
                for (int x = 0 ; x < resultsArray.length ; ++x)
                {
                    if (resultsArray[x] instanceof Candidate)
                    {
                        results.add (resultsArray[x]);
                    }
                    else
                    {
                        // Ignore
                    }
                }
                
                resultsArray = new BaseBusinessClass[results.size ()];
                results.copyInto (resultsArray);

                return resultsArray;
            
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension", PersistentSetStatus.FETCHED);
        
            // Object Modified
            oneit_sec_user_extensionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            oneit_sec_user_extensionPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));oneit_sec_user_extensionPSet.setAttrib("OBJECT_TYPE", r.getString ("OBJECT_TYPE"));

        oneit_sec_user_extensionPSet.setAttrib(Candidate.FIELD_Phone, HELPER_Phone.getFromRS(dummyPhone, r, "phone"));
        
        oneit_sec_user_extensionPSet.setAttrib(Candidate.SINGLEREFERENCE_TestInput, r.getObject ("test_input_id"));
        oneit_sec_user_extensionPSet.setAttrib(Candidate.SINGLEREFERENCE_User, r.getObject ("user_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet oneit_sec_user_extensionPSet = allPSets.getPersistentSet(objectID, "oneit_sec_user_extension");
        

        
        if (oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            oneit_sec_user_extensionPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}oneit_sec_user_extension " +
                                     "  (phone,  test_input_id, user_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE, object_TYPE) " +
                                     "VALUES " +
                                     "  (?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ", ?)",
                                     CollectionUtils.listEntry (HELPER_Phone.getForSQL(dummyPhone, oneit_sec_user_extensionPSet.getAttrib (Candidate.FIELD_Phone))) .listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (Candidate.SINGLEREFERENCE_TestInput)))).listEntry (SQLManager.CheckNull((Long)(oneit_sec_user_extensionPSet.getAttrib (Candidate.SINGLEREFERENCE_User)))) .listEntry (objectID.longID ()).listEntry (context.getTag (obj)).toList().toArray());

            oneit_sec_user_extensionPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
