import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { SearchService } from './../../services/search.service';
import { of } from 'rxjs/observable/of';


@Injectable()

export class FeedbackService {

    feedbackInfo: any;
    public feedbackInitiated: boolean;
    
    constructor(
        private searchService: SearchService
    ) {
    }

    getFeedbackInfo(): Observable<any> {
        if (!this.feedbackInfo) {
            return this.searchService.getObjects("FeedbackInfo", null, {}, [], null, null, null, null).map(
                data => {
                    this.feedbackInfo = data;
                    return data;
                }
            );
        }
        return of(this.feedbackInfo);
    }
}