import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { takeUntil } from 'rxjs/operators';
import { CareerProfileModel } from '../../models/career-profile.model';
import { HelperService } from '../../services/helper.service';
import { UtilsService } from '../../../../oneit/services/utils.service';

@Component({
    selector: 'app-profile-tasks',
    templateUrl: './profile-tasks.component.html',
    styleUrls: ['./profile-tasks.component.scss']
})
export class ProfileTasksComponent extends BaseComponent implements OnInit {

    assocs = ['Candidate.User', 'Candidate.OccupationPreference'];
    careerProfile = new CareerProfileModel();
    avatarBorder = 'linear-gradient(90deg, transparent 50%, #EAECEE 50%), linear-gradient(90deg, #EAECEE 50%, transparent 50%)';

    constructor(
        private hs: HelperService,
        private us: UtilsService,
        private ps: PersonalDetailsService
    ) {
        super();
    }

    ngOnInit() {
        this.getCareerProfile();
        this.ps.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(profile => {
                this.careerProfile = this.us.cloneObject(profile);
                this.setProfileCompletion();
            })
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.ps.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.careerProfile = response;
                this.setProfileCompletion();
                this.isLoading = false;
            }, err => {
                this.hs.handleHttpError(err);
                this.isLoading = false;
            })
    }

    setProfileCompletion(): void {
        const percentage = (this.careerProfile.CompletedPercentage || 0) * 3.6;
        const degree =  percentage <= 180 ? 90 + percentage : percentage - 90;
        this.avatarBorder = `linear-gradient(${degree}deg, transparent 50%, #EAECEE 50%), linear-gradient(90deg, #EAECEE 50%, transparent 50%)`;
    }

}
