import { Component } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { PersonalDetailsService } from '../../services/personal-details.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { CareerProfileModel } from '../../models/career-profile.model';

@Component({
    selector: 'app-profile-tasks',
    templateUrl: './profile-tasks.component.html',
    styleUrls: ['./profile-tasks.component.scss']
})
export class ProfileTasksComponent extends BaseComponent {

    careerProfile = new CareerProfileModel();
    avatarBorder = 'linear-gradient(90deg, transparent 50%, #EAECEE 50%), linear-gradient(90deg, #EAECEE 50%, transparent 50%)';
    backgroundColor = '#1469A2';
    assocs = ['Candidate.User', 'Candidate.OccupationPreference'];
    profileTasks = [
        {label: 'Personal Details', link: '/my-career-web/dashboard/personal-details', key: 'CompletedPercentage', inProgress: false, completed: false, started: false},
        {label: 'Work Strengths', link: '/my-career-web/assessments/work-style', key: 'CompletedPercentageWS', inProgress: false, completed: false, allowEditField: 'AllowResubmitWS', started: false},
        {label: 'Career Values', link: '/my-career-web/assessments/work-preference', key: 'CompletedPercentageWP', inProgress: false, completed: false, allowEditField: 'AllowResubmitWP', started: false},
        {label: 'Career History', link: '/my-career-web/career-history/personal-data', key: 'CompletedPercentageCH', inProgress: false, completed: false, started: false},
        {label: 'Diversity', link: '/my-career-web/assessments/diversity-profile', key: 'CompletedPercentageDiv', inProgress: false, completed: false, started: false}
    ];

    constructor(
        private personalDetailsService: PersonalDetailsService,
        private utilsService: UtilsService
    ) {
        super();
    }

    ngOnInit() {
        this.personalDetailsService.careerProfileUpdated$
            .pipe(takeUntil(this.componentInView))
            .subscribe(profile => {
                this.careerProfile = this.utilsService.cloneObject(profile);
                this.getCareerProfile();
            });
        this.getCareerProfile();
    }

    getCareerProfile(): void {
        this.isLoading = true;
        this.personalDetailsService.getCareerProfile(this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.careerProfile = response;
                this.setProfileCompletion();
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

    setProfileCompletion(): void {
        this.profileTasks.forEach(t => {
            t.completed = false;
            t.inProgress = false;
            t.started = false;
            if (this.careerProfile[t.key] === 100) {
                t.completed = true;
            } else if (this.careerProfile[t.key] > 0 && this.careerProfile[t.key] <= 100) {
                t.inProgress = true;
            }
        });
        const currentTask = this.profileTasks.find(t => !this.careerProfile[t.key]);
        currentTask.started = true;
        // const percentage =  (this.careerProfile.CompletedPercentage || 0) * 3.6;
        // for (let i = 0; i <= percentage; i++) {
        //     if (percentage === 360) {
        //         this.backgroundColor = '#1DBA3C';
        //         this.avatarBorder = `linear-gradient(${90 + percentage}deg, transparent 50%, #1DBA3C 50%),linear-gradient(90deg, #1DBA3C 50%, transparent 50%)`;
        //     } else if (percentage<=180){
        //         this.avatarBorder = `linear-gradient(${90 + percentage}deg, transparent 50%, #EAECEE 50%),linear-gradient(90deg, #EAECEE 50%, transparent 50%)`;
        //     } else {
        //         this.avatarBorder = `linear-gradient(${percentage - 90}deg, transparent 50%, #1469A2 50%),linear-gradient(90deg, #EAECEE 50%, transparent 50%)`;
        //     }
        // }
    }

}
