<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran         =   process.getTransaction ();
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Job                 job             =   jobApplication.getJob();
    String              exitPage        =   WebUtils.getArticleLink(request, objTran, WebUtils.APPLY_JOB, "Page");
    exitPage                            =   exitPage + "&id=" + job.getID() + "&key=" + job.getRandomKey();
    
    jobApplication.initCCAnswers();
%>
    <script>
        $(document.body).addClass('bg-color');
    </script>

    <div class="main-application-outline">
        <div class="selection-aust-logo">
            <img src="images/australia-post.png" />
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Section 2 - Workplace Culture</div>
            <div class="mobile-estimated">Estimated time to complete: <b>5 mins</b></div>
        </div>
        <div class="section-title m-hide">Section 2</div>
        <div class="section-c-title m-hide">
            Workplace Culture
            <span>Estimated time to complete: <b>5 mins</b></span>
        </div>
        <div class="section-tab-view">

            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">

                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="2"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area">
                    <div class="main-sc-section">
                        <p>
                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean semper at magna a
                            tristique. Ut ut magna ut mauris sagittis placerat. Suspendisse vitae tempus sem. Lorem
                            ipsum dolor sit amet, consectetur adipiscing elit.
                        </p>
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section main-wc-section">
                    <%
                        FormTag     applicationForm =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder     =   applicationForm.getFormBuilder();
                        int         i               =   1;
                        int         size            =   jobApplication.getCultureCriteriaAnswersCount();
                        
                        for(CultureCriteriaAnswer   answer: jobApplication.getCultureCriteriaAnswersSet())
                        {
                            CultureCriteria                     criteria    = answer.getCultureCriteria();
                            Collection<CultureElementQuestion>  questions   = criteria.pipelineCultureCriteria().toCultureElement().toQuestions().vals();
                            String                              optionKey   = WebUtils.getRadioSingleAssocKey(request, answer, CultureCriteriaAnswer.SINGLEREFERENCE_SelectedQuestion);
                            String                              formValue   = formBuilder.fieldValue (optionKey, answer.getSelectedQuestion() == null ? "" : String.valueOf(answer.getSelectedQuestionID()));
                    %>
                            <div class="selection-form-title">Question <%= i++%></div>
                            <div class="form-group-new question-y-n">
                            <%
                                for(CultureElementQuestion question : questions)
                                {
                                    String  questionId  = String.valueOf(question.getID().longID());
                                    String  selectedStr = (CollectionUtils.equals(questionId, formValue) ? "checked" : "");
                            %>
                                    <div class="radio radio-primary second-radio-primary full-width">
                                        <input type="radio" name="<%= optionKey %>" id="<%= questionId %>"  value="<%= questionId %>" <%= selectedStr %> >
                                        <label for="<%= questionId %>">
                                            <oneit:toString value="<%= question.getDescription() %>"    mode="EscapeHTML"   nullValue="-"/>
                                        </label>
                                    </div>
                            <%
                                }
                            %>
                            </div>
                            
                        <%
                            if(i<=size)
                            {
                        %>
                                <div class="section-br-inside"></div>
                        <%
                            }
                        %>
                    <%
                        }
                    %>
                    </div>
                    <div class="selection-br-line"></div>
                    <div class="main-sc-section btn-remove-padd">
                        <div class="section-btn text-center">
                            <oneit:button   value="Save and exit"   name="save" cssClass="box-btn-gray"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", exitPage)
                                                                            .mapEntry ("procParams", Collections.singletonMap("id", "XXXXXXXXXXX"))
                                                                            .toMap() %>"/>
                            <oneit:button   value="Proceed to step 3"   name="gotoPage" cssClass="box-btn"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                            .toMap() %>"/>
                        </div>
                    </div>
                </div>
            </oneit:form>
        </div>
    </div>
</oneit:dynIncluded>