package performa.form;

import java.util.Map;
import oneit.logging.*;
import oneit.objstore.StorageException;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.*;
import performa.orm.*;
import performa.orm.types.ApplicationStatus;
 

public class CompleteApplicationFP extends SaveFP
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException 
    {
        JobApplication  jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
        
        jobApplication.setApplicationStatus(ApplicationStatus.SUBMITTED);
        
        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING2, "Job Application Completed", jobApplication);
        
        return super.processForm(process, submission, params);
    }
}