<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils" %>

<oneit:dynIncluded>
<%
    String              currentPage     =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
    Long                jobAppId        =   (Long) process.getAttribute("JobApplicationID");
    JobApplication      jobApplication  =   null;

    if(jobAppId != null)
    {
        jobApplication  =   JobApplication.getJobApplicationByID(objTran, jobAppId);
    }
    else
    {
        jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
        
        process.setAttribute("JobApplicationID" , jobApplication.getID().longValue());
    }

    Debug.assertion(jobApplication != null, "Job Application cannot be null in applicant  portal - job match assessment ");

    Job                 job             =   jobApplication.getJob();
    Candidate           candidate       =   jobApplication.getCandidate();
    int                 questionNumber  =   process.getAttribute("QuestionNumber")!= null ? (int) process.getAttribute("QuestionNumber") : jobApplication.getQuestionNumber();
    int                 actualNumber    =   process.getAttribute("ActualNumber")!= null ? (int) process.getAttribute("ActualNumber") : jobApplication.getActualQuestionNumber();
    List<Question>      totalQuestions  =   (List<Question>) process.getAttribute("TotalQuestions");
    List<Question>      allQuestions    =   (List<Question>) process.getAttribute("AllQuestions");
    String              exitPage        =   WebUtils.getArticleLink(request, transaction, WebUtils.APPLY_JOB, "Page") + "&id=" + job.getID() + "&key=" + job.getRandomKey();

    if(totalQuestions == null)
    {
        totalQuestions  =   job.getAllQuestions();
        
        process.setAttribute("TotalQuestions", totalQuestions);
    }

    if(allQuestions == null)
    {
        allQuestions    =   job.getAllLeftQuestions(totalQuestions);
        
        process.setAttribute("AllQuestions", allQuestions);
    }

    //to store current question number in history
    if(process.getAttribute("QuestionNumber")==null || process.getAttribute("ActualNumber")==null)
    {
        request.getSession().setAttribute ("historyQstNo", null);
        request.getSession().setAttribute ("historyActualNo", null);
    }
    
    if(request.getSession().getAttribute("historyQstNo")!=null && process.getAttribute("QuestionNumber")!= null)
    {
        if((int) process.getAttribute("QuestionNumber") <= (int) request.getSession().getAttribute("historyQstNo"))
        {
            questionNumber   =   (int) request.getSession().getAttribute("historyQstNo");
        }
    }
    
    if(request.getSession().getAttribute("historyActualNo")!=null && process.getAttribute("ActualNumber")!= null)
    {
        if((int) process.getAttribute("ActualNumber") <= (int) request.getSession().getAttribute("historyActualNo"))
        {
            actualNumber   =   (int) request.getSession().getAttribute("historyActualNo");
        }
    }
    
    request.getSession().setAttribute ("historyQstNo", questionNumber);
    request.getSession().setAttribute ("historyActualNo", actualNumber);
    
//    boolean toRedirect  =   jobApplication.initAssessmentAnswers(allQuestions);
//    
//    if(toRedirect)
//    {
//        process.setAttribute("QuestionNumber", questionNumber);
//        process.setAttribute("ActualNumber", actualNumber);
//
//    }

    Question        question        =   (Question) allQuestions.get(questionNumber).getInTransaction (objTran);
    QuestionType    questionType    =   question.getQuestionType();
%>
    <script>
        $(document.body).addClass('bg-color');
        
        $(document).ready(function(){
            
            $(".answer_radio").change(function(){
                $(".ratting-number li.active").removeClass("active" );
                $(".ratting-number input[type='radio']:checked").closest('li').addClass("active" );
            });
        });
        
        function gotoNextQuestion(questionNumber, actualNumber, completeApplication, answerNo)
        {
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/applicantportal/inc/save_job_match_answers.jsp", 'form' , 
                {questionNumber : questionNumber, answerNo: answerNo, actualNumber: actualNumber, completeApplication: completeApplication}, 
                function () {}, 
                function (jqXHR, textStatus, errorThrown) {
                    if (jqXHR.status == 0) {
                        log("Empty Response. Status : " + jqXHR.status);
                    } else {
                        window.alert("Error processing request:" + errorThrown);
                    }
                }, 
            "POST");
            if(completeApplication)
            {
                $("#gotoPageNext").click();
                return false;
            }

            $('.section-job-match').empty();
            ajaxProcessAddJQ ("<%= request.getContextPath() %>/extensions/applicantportal/inc/job_match_questions.jsp", '.section-job-match' , {questionNumber : questionNumber, actualNumber: actualNumber});
            
        }
    </script>
    
    <div class="main-application-outline">
        <div class="selection-aust-logo">
        <%
            BinaryContent   logo    =   job.getLogo();
        
            if(logo != null)
            {
                int logoHeight  =   45;
        %>
                <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
        <%
            }
        %>
            <span><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></span>
            <div class="clearfix no-height"></div>
        </div>
        <div class="show-mobile-title">
            <div class="mobile-title-page">Your Work Style</div>
            <div class="mobile-estimated">Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </div>
        </div>
        <div class="section-c-title m-hide">
            Your Work Style
            <span>Estimated time to complete: 
                <span class="estimated-time-20">&nbsp;20 mins</span>
            </span>
        </div>
        <div class="section-tab-view">
            
            <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
            
                <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"           data="<%= CollectionUtils.EMPTY_MAP%>"/>
                
                <oneit:dynInclude   page="/extensions/applicantportal/inc/application_main_tabs.jsp"    PageNumber="3"  data="<%= CollectionUtils.EMPTY_MAP%>"/>

                <div class="section-page-area section-job-match">
                   
                    <oneit:dynInclude   page="/extensions/applicantportal/inc/job_match_questions.jsp"  
                                        actualNumber="<%= actualNumber %>"
                                        questionNumber  ="<%= questionNumber %>"
                                        data="<%= CollectionUtils.EMPTY_MAP%>"/>
                </div>
            </oneit:form>
        </div>
</oneit:dynIncluded>