import { Injectable } from '@angular/core';
import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class SearchApplicantService {

    constructor(private searchService : SearchService,
            private utilsService : UtilsService) {

    }

    getApplicants(ob, assocs) {
        return this.searchService.getObjects('Candidates', 'All', ob, assocs, null, null, null, null)
        .map(
            data =>
                this.utilsService.convertResponseToObjects(data, assocs)
        );
    }
}