import { BaseModel } from './base.model';
import { CandidateModel } from './candidate.model';
import { CLASSES } from '../config/constants';
import { WorkExperienceModel } from './work-experience.model';
import { EducationModel } from './education.model';
import { CareerSkillModel } from './career-skill.model';
import { RefereeModel } from './referee.model';

export class CareerProfileModel extends BaseModel {
    ObjectClass = CLASSES.CAREER_PROFILE;
    Mobile: string;
    GoogleAddress: string;
    Skype: string;
    Candidate = new CandidateModel();
    CompletedPercentage: number;
    PersonalStatement: string;
    Achievements: string;
    IsGoogleConnected: boolean;
    IsLinkedInConnected: boolean;
    WorkExperiences: WorkExperienceModel[] = [];
    EducationCertificates: EducationModel[] = [];
    Skills: CareerSkillModel[] = [];
    Referees: RefereeModel[] = [];
    NoWorkExperience: boolean;
    NoEducationQualification: boolean;
    NoReference: boolean;
    PublishProfile: boolean;
    AssumedUser: boolean;
    ProfileBulderTabCompletion: {
        EDUCATION: boolean;
        PERSONAL_DATA: boolean;
        PUBLISH: boolean;
        REFERENCES: boolean;
        SKILLS: boolean;
        TEMPLATES: boolean;
        WORK_HISTORY: boolean;
    };
    Template: any;
}
