import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { DashboardComponent } from './dashboard/dashboard.component';
import { HomeComponent } from './home/home.component';
import { PersonalDetailsComponent } from '../mc-shared/personal-details/personal-details.component';
import { GoPremiumComponent } from './go-premium/go-premium.component';
import { SummaryReportComponent } from './summary-report/summary-report.component';

const routes: Routes = [
    {
        path: '',
        component: DashboardComponent,
        children: [
            {
                path: 'home',
                component: HomeComponent
            },
            {
                path: 'personal-details',
                component: PersonalDetailsComponent
            },
            {
                path: 'go-premium',
                component: GoPremiumComponent
            },
            {
                path: 'reports',
                component: SummaryReportComponent
            },
            {
                path: '',
                redirectTo: 'home',
                pathMatch: 'full'
            }
        ]
    }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class DashboardRouting { }
