import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { SearchService } from '../../../oneit/services/search.service';
import { UtilsService } from '../../../oneit/services/utils.service';

@Injectable()
export class AssessmentService {

  constructor(
      private us: UtilsService,
      private ss: SearchService
  ) { }

  getWorkStyle(assocs = []): Observable<any> {
      return this.ss.getObjects('WorkStyle', 'All', '', assocs, null, null, null, null)
          .map(
              data => {
                  return this.us.convertResponseToObjects(data, assocs);
              }
          )
  }

  saveWorkStyle(params): Observable<any> {
      return this.us.processObjects('SaveWorkStyle', params);
  }


}
