import { Component, OnInit, OnDestroy } from '@angular/core';
import { Router } from '@angular/router';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { ConfirmEditService } from './confirm-edit.service';


@Component({
    selector: 'app-confirm-edit',
    templateUrl: './confirm-edit.component.html'
})
export class ConfirmEditComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    
    messageTemplateTypes: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private confirmEditService: ConfirmEditService
    ){
        
    }

    ngOnInit() {

        this.getMessageTemplateTypes();
    }
    

    getMessageTemplateTypes() {
        this.subscriptions.push(this.confirmEditService.getMessageTemplateTypes([])
            .subscribe(
                data => {
                    this.messageTemplateTypes = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}