<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    boolean toRedirect  =   GenericObjDF.getOrCreateObject (request, "Job", Job.REFERENCE_Job);
    Job     job         =   (Job) process.getAttribute("Job");

    Debug.assertion(job != null && !toRedirect, "Invalid job in applicant portal");

    SecUser     secUser     =   SecUser.getTXUser(transaction);
    
    Debug.assertion(secUser != null, "Invalid candidate in applicant portal");
    
    Candidate   candidate   =   secUser.getExtension(Candidate.REFERENCE_Candidate);

    Debug.assertion(candidate != null, "Invalid candidate in applicant portal");

    String          successPage     =   WebUtils.getSamePageInRenderMode(request, "VerificationSent") + "&JobID=" + job.getID();
    JobApplication  jobApplication  =   JobApplication.searchCandidateJob(transaction, candidate, job);
    boolean         redirectUser    =   jobApplication != null && jobApplication.getApplicationStatus() == ApplicationStatus.DRAFT;

    if(jobApplication == null)
    {
        jobApplication  =   JobApplication.createNewApplication(candidate, job);
    }

    Boolean isSelectionComplete     =   jobApplication.selectionCompleted();
    Boolean isCultureComplete       =   jobApplication.cultureCompleted();
    Boolean isAssesmentComplete     =   jobApplication.assessmentCompleted();
    Article jobApplicationArticle   =   WebUtils.getArticleByShortCut(transaction, WebUtils.JOB_APPLICATION);
    String  nextPage                =   jobApplicationArticle.getLink(request);

    if(!jobApplication.hasStartedApplication())
    {
        nextPage    =   WebUtils.getArticleLink(request, transaction, WebUtils.JOB_APPLICATION, "Page") + "&JobID="+ job.getID().toString();
    }
    else if(!isSelectionComplete)
    {
        nextPage    =   LoopbackHTTP.getRemoteAccessURL(request)
                                        + jobApplicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "SelectionCriteria").toMap(), "/");
    }
    else if(!isCultureComplete)
    {
        nextPage    =   LoopbackHTTP.getRemoteAccessURL(request)
                                        + jobApplicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "WorkplaceCulture").toMap(), "/");
    }
    else if(!isAssesmentComplete)
    {
        nextPage    =   LoopbackHTTP.getRemoteAccessURL(request)
                                        + jobApplicationArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", "JobMatchAssessment").toMap(), "/");
    }
    

    if(redirectUser)
    {
        response.sendRedirect(candidate.isFalse(candidate.getIsAccountVerified()) ? successPage : nextPage +"&JobApplicationID="+ jobApplication.getID().toString());
    }

    candidate.setHasValidAddress(candidate.getGoogleAddressText() != null);

    process.setAttribute("JobApplication", jobApplication);
%>
    <oneit:script>
        <oneit:script src="/scripts/password_strength_lightweight.js"/>
    </oneit:script>   
    <style>
        button[disabled] {
            opacity: 0.6;
            background-color: #0582ba;
        }
        
        .email input[name$="Email"] {
            opacity: 0;
            position: absolute;
        }
    </style>
    
    <oneit:form name="signIn" method="post" enctype="multipart/form-data">
        <script type="text/javascript">
            $(document.body).addClass('bg-color');
            var  interval ;
            $(document).ready(function() {
                recalcFunction = setupRecalc ($("form#signIn"), {'recalcOnError':true});
                
                $(".fileLink").hide();
                
                interval =  setInterval(function() { validate(); }, 500);
                validate();
                $('input').on('change keyup', function() { validate(); });
            });
 
            function validate() {
                var empty = false;
                $('input[required]').each(function() {
                    if ($( this ).val() == '') {
                        empty = true;
                        if ($( this ).css('background-color') == 'rgb(250, 255, 189)') {
                           empty = false;
                        }
                    }
                });

                if (empty) {
                    $('.verify-btn').attr('disabled', 'disabled');
                } else {
                    $('.verify-btn').removeAttr('disabled');
                     clearInterval(interval);
                }
            }
        </script>
        <script type="text/javascript">
            $(document.body).addClass('bg-color');

            $(document).ready(function(){
                $('.attach-icon-btn').click(function(){
                   $(this).parent().find("input").click(); 
                });

                $("input:file").change(function (){
                    var fullPath = $(this).val();
                    var filename = fullPath.replace(/^.*[\\\/]/, '');
                    
                    if (filename)
                    {
                        $(this).parents(".fileInput").siblings(".new-file-link").text(filename);
                        $(this).parents(".fileInput").siblings(".new-file-link").removeAttr("href"); 
                    }
                });
            });
        </script>
        <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&key=AIzaSyCaBh-MsMb8BBYJD_NcFzoCmygQbt5-QSw"></script>
        <oneit:script>
            <oneit:script src="/scripts/google_address.js"/>
        </oneit:script>
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
        <div class="apply-job-logo-header signinpage">
             <div class="box-sizing-border-box">
                <div class="logo-img">
                <%
                    BinaryContent   logo    =   job.getLogo();

                    if(logo != null)
                    {
                        int logoHeight  =   45;
                %>
                        <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
                <%
                    }
                %>
                </div>
                <div class="header-title">
                    <%= job.getTeamName() %>
                </div>
            </div>
        </div>
        <div class="main-verify-identity">
       
            <div class="pl-confirm text-center">Please confirm your details to continue</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left">
                    <label>Email Address</label>
                    <%
                        if(secUser.getEmail() == null || (candidate.isUnverifiedEmailIngestUser() && candidate.isTrue(candidate.getIsMaskedEmail())))
                        {
                    %>
                            <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="Email"   cssClass="form-control"    style="text-transform: lowercase"    required="true"/>
                    <%
                        }
                        else
                        {
                    %>
                            <oneit:ormInput obj="<%= secUser %>"        type="text" attributeName="Email"    cssClass="form-control second-style"    disabled="true" readonly="true"/>
                    <%
                        }
                    %>
                </div>
                <%

                    if(!candidate.isTrue(candidate.getIsPasswordChanged()))
                    {
                        String  passkey =   Utils.getPwdKeyOfSecUser(request, secUser, true);
                %>
                        <script type="text/javascript">
                            $(document).ready(function() {
                               $('#myPassword').strength_meter({
                                    "inputName" : "<%= passkey %>"
                                });
                            });
                        </script>
                        <div class="form-group text-left email">
                            <label style="display: none;"><oneit:ormlabel  obj="<%= secUser %>"    field="Email" /></label>
                            <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="Email"       cssClass="form-control"/>
                        </div>
                        <div class="form-group text-left"   id="myPassword">
                            <label>Password</label>
                        </div>
                        <div class="form-group text-left">
                            <label>Confirm password</label>
                            <oneit:input    type="password" name="<%= passkey + 2 %>"   class="form-control second-style reset-pw"/>
                        </div>
                
                <%
                    }
                %>
                <div class="row">
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="FirstName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="FirstName"   cssClass="form-control second-style"    required="true"/>
                    </div>
                    <div class="form-group text-left col-sm-6 col-xs-12">
                        <label><oneit:ormlabel  obj="<%= secUser %>"    field="LastName" /></label>
                        <oneit:ormInput obj="<%= secUser %>"    type="text" attributeName="LastName"    cssClass="form-control second-style"    required="true"/>
                    </div>
                </div>
                <div class="form-group text-left">
                    <label><oneit:ormlabel  obj="<%= candidate %>"    field="Phone" /></label>
                    <oneit:ormInput obj="<%= candidate %>"      type="text" attributeName="Phone"       cssClass="form-control second-style"    required="true"/>
                </div>
                <%
                    if(job.getRequireCV())
                    {
                %>
                        <div class="form-group text-left relative-parent ">
                            <label>Upload your CV (PDF preferred)</label>
                            <div class="form-control second-style">
                                <a target='blank' class="new-file-link" href='<%= request.getContextPath() + "/" + BinaryContentHandler.getRelativeURL(request, jobApplication, "CV", jobApplication.getCV(), true) %>'>
                                    <%= jobApplication.getCV() != null ?  "Click to View File" :  "" %>
                                </a>
                                <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CV"          cssClass="hide"/>
                                <div class="attach-icon-btn"></div>
                            </div>
                        </div>
                        <div class="form-group text-left relative-parent">
                            <label>Upload your Cover Letter (PDF preferred)</label>
                            <div class="form-control second-style">
                                <a target='blank' class="new-file-link" href='<%= request.getContextPath() + "/" + BinaryContentHandler.getRelativeURL(request, jobApplication, "CoverLetter", jobApplication.getCoverLetter(), true) %>'>
                                    <%= jobApplication.getCoverLetter() != null ?  "Click to View File" :  "" %>
                                </a>
                                <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CoverLetter" cssClass="hide"/>
                                <div class="attach-icon-btn"></div>
                            </div>
                        </div>
                <%
                    }
                %>  
                <hr class="seperate-line">
                <div class="form-group text-left">
                    <label>Location</label>
                    <div class="googleAddress">
                        <oneit:ormInput obj="<%= candidate %>"  class="has-valid-address"   attributeName="HasValidAddress"  type="checkbox"/>
                        <oneit:ormInput obj="<%= candidate %>"  type="text" attributeName="GoogleAddressText" class="autoAddress" id="<%= "gAddress_"+candidate.getObjectID() %>" placeholder="Enter your address" cssClass="form-control" />
                    </div>
                </div>
                <div class="form-group text-left" style="margin-top: 30px;">
                    <div class="styled_checkboxes">
                        <div class="checkbox checkbox-primary">
                            <oneit:ormInput obj="<%= jobApplication %>"  id="prefer-remote"    attributeName="PreferRemote"  type="checkbox"/>
                            <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.getPreferRemote() ? 'checked': 'unchecked'"    jobApplication="<%= jobApplication %>">
                                <label for="prefer-remote">
                                    <oneit:label GUIName="I would prefer to work remotely" />
                                </label>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
                <oneit:recalcClass  htmlTag="div"  classScript="jobApplication.isFarFromJob() ? 'show': 'hide'"    jobApplication="<%= jobApplication %>">
                    <div class="relocate-warning-box">               
                        <p>
                            We noticed that your location is different to the location of the job (<%= job.getGoogleAddressText() %>).
                        </p>
                        <p>
                            Are you prepared to relocate for this position?
                        </p>   

                        <div class="styled_checkboxes">
                            <div class="checkbox checkbox-primary">
                                <oneit:ormInput obj="<%= jobApplication %>"  id="happy-to-relocate"  attributeName="HappyToRelocate" type="checkbox" />
                                <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.getHappyToRelocate() ? 'checked': 'unchecked'"    jobApplication="<%= jobApplication %>">
                                    <label for="happy-to-relocate">
                                        <oneit:label GUIName="Yes, I am happy to relocate"/>
                                    </label>
                                </oneit:recalcClass>
                            </div>
                        </div>
                       <span class="warning-icon"></span>
                    </div>  
                </oneit:recalcClass>
                <div class="form-group text-left">
                    <div class="styled_checkboxes">
                        <div class="checkbox checkbox-primary">
                            <oneit:ormInput obj="<%= candidate %>"  id="privacy-policy-agreed"  attributeName="PrivacyPolicyAgreed" type="checkbox" />
                            <oneit:recalcClass  htmlTag="span"  classScript="candidate.showPrivacyPolicyAgreed() ? 'checked': 'unchecked'"    candidate="<%= candidate %>">
                                <label for="privacy-policy-agreed">
                                    <oneit:label GUIName="I have read and agree to the " />
                                    <a href="https://www.matchd.com/privacy/" target="_blank" class="privacy-link">Privacy Policy</a>
                                </label>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
                <div class="form-group text-left">
                    <div class="styled_checkboxes">
                        <div class="checkbox checkbox-primary">
                            <oneit:ormInput obj="<%= candidate %>"  id="conditions-agreed"  attributeName="ConditionsAgreed" type="checkbox"    />
                            <oneit:recalcClass  htmlTag="span"  classScript="candidate.showConditionsAgreed() ? 'checked': 'unchecked'"    candidate="<%= candidate %>">
                                <label for="conditions-agreed">
                                    <oneit:label GUIName="I have read and agree to the " />
                                    <a href="https://www.matchd.com/terms-of-service/" target="_blank" class="privacy-link">Terms & Conditions</a>
                                </label>
                            </oneit:recalcClass>
                        </div>
                    </div>
                </div>
                <div class="text-center">
                    <oneit:button   value="Submit"   name="sendVerificationMail"    cssClass="box-btn send-link-btn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", successPage)
                                                                        .mapEntry("Job",job)
                                                                        .mapEntry("Candidate",candidate)
                                                                        .mapEntry("JobApplication",jobApplication)
                                                                        .mapEntry(NotificationUtils.NOTIFICATION_MSG_PARAM, "emailSent")
                                                                        .toMap() %>"/>
                </div>
            </div>
        </div>
        <script>
            addGoogleAddressListener('#<%= "gAddress_"+ candidate.getObjectID() %>');
        </script>
    </oneit:form>
</oneit:dynIncluded>