<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran         =   process.getTransaction ();
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String              shortlistPage   =   WebUtils.getSamePageInRenderMode(request, WebUtils.APPLICANTS_SHORTLIST);
    String              homePage        =   WebUtils.getSamePageInRenderMode(request, "Page");
    JobStatus           jobStatus       =   (JobStatus) session.getAttribute("JobStatus"); 
    JobSortOption       jobSortOpt      =   (JobSortOption) process.getAttribute("JobSortOption");
    
    if( request.getParameter("JobSortOption") != null)
    {
        jobSortOpt  =   JobSortOption.forName((String) request.getParameter("JobSortOption"));
    }
    
    if(jobSortOpt == null)
    {
        jobSortOpt  =   JobSortOption.NEWEST;
    }
    
    String              jobListName =   "Job" + jobStatus;
    Job[]               jobs        =   (Job[]) process.getAttribute(jobListName);
    
    if(jobs==null)
    {
        jobs    =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(jobStatus))
                                    .andSecUser(new EqualsFilter(SecUser.getTXUser(transaction)))
                                    .search(transaction);
        
        process.setAttribute(jobListName, jobs);
    }
    
    List<Job>           sortedJobs  =   Utils.getJobsSorted(jobs, jobSortOpt, jobStatus);
    
    process.setAttribute("JobSortOption", jobSortOpt);
%>
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">

        <div class="dashboard-content-area second-part">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <div class="jobs-list-shorting">
                <div class="d-job-title all-jobs-title">All Jobs</div>
                <div class="job-filter">
                    <ul class="">
                        <li class="lable-job-shorting">showing</li>
                        <li class="<%= (jobStatus == null ? "active" : "" )%>">
                            <oneit:button   value="All Jobs"    name="navigateBetweenStatus"    skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage)
                                                                            .mapEntry("JobStatus", null)
                                                                            .toMap() %>"/>
                        </li>
                        <%
                            for (JobStatus status : JobStatus.getJobStatusArray())
                            {
                        %>
                                <li class="<%= (jobStatus != null && jobStatus == status ? "active" : "" )%>">
                                    <oneit:button   value="<%= status.getDescription() %>"  name="navigateBetweenStatus"    skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage )
                                                                                    .mapEntry("JobStatus", status)
                                                                                    .toMap() %>"/>
                                </li>
                        <%
                            }
                        %>
                    </ul>
                </div>
                <div class="shorting-dropdown">
                    <span class="order-label">order by</span>
                    <select class="form-control"    onChange="location=this.value">
                        <%
                            for (JobSortOption  sortOption : JobSortOption.getJobSortOptionArray())
                            {
                                String  optionLink  =    homePage + "&JobSortOption=" + sortOption.getName() ;
                        %>
                                <option <%= (jobSortOpt != null && jobSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                    <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                </option>
                        <%
                            }
                        %>
                    </select>
                </div>
            </div>
                    
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_list.jsp" data="<%= CollectionUtils.EMPTY_MAP%>"  ShortlistPage="<%= shortlistPage %>"
                                NextPage="<%= nextPage%>"   HomePage="<%= homePage%>"   Jobs="<%= sortedJobs.toArray(new Job[0]) %>"    JobStatus="<%= jobStatus %>"
                                JobSortOption="<%= jobSortOpt %>" />
            
        </div>
    </oneit:form>
</oneit:dynIncluded>
