package performa.form;

import com.stripe.Stripe;
import com.stripe.model.Plan;
import com.stripe.model.PlanCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import oneit.appservices.config.ConfigMgr;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import performa.orm.Job;


public class ManagePlansFP  extends SaveFP
{

    public static final String  STRIPE_KEY      = ConfigMgr.getKeyfileString("stripe.key","");
    public static final String  STRIPE_PUB_KEY  = ConfigMgr.getKeyfileString("stripe.pubkey","");
    
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map p) throws BusinessException, StorageException
    {
        HttpServletRequest  request =   submission.getRequest();
        
        LogMgr.log(Job.LOG, LogLevel.PROCESSING1,"In ManagePlansFP : " );

        Stripe.apiKey = STRIPE_KEY;
            
        try {
            Map<String, Object> planParams = new HashMap<>();

            PlanCollection list = Plan.list(planParams);
                    
            List<Plan> lists = list.getData();
            
            for (Plan plan : lists)
            {
                
//                Map<String, String> metadata    =   plan.getMetadata();
//                PaymentPlan         paymentPlan =   PaymentPlan.createPaymentPlan(process.getTransaction());
//                
//                paymentPlan.setStripeReference(plan.getId());
//                paymentPlan.setPlanName(plan.getName());
//                paymentPlan.setDescription(plan.getStatementDescriptor());
//                paymentPlan.setCurrencyType(CurrencyType.forName(plan.getCurrency().toUpperCase()));
//                paymentPlan.setAmount(plan.getAmount().doubleValue());
//                paymentPlan.setInterval(Interval.forName(plan.getInterval().toUpperCase()));
//                paymentPlan.setIntervalCount(plan.getIntervalCount());
//                paymentPlan.setTrialPeriodDays(plan.getTrialPeriodDays());
//                paymentPlan.setActiveJobCount(Integer.valueOf(metadata.get("ActiveJobs")));
            }
            
        } catch (Exception ex) 
        {
            Logger.getLogger(ManagePlansFP.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return super.processForm(process, submission, p);
    }
}
