
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;
import performa.orm.types.TimeZone;
import oneit.business.shopping.orm.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class HiringTeamPersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea HiringTeamPersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "HiringTeam");

    // Private attributes corresponding to business object data
    private String dummyHiringTeamName;
    private BinaryContent dummyHiringTeamLogo;
    private HiringTeamType dummyHiringTeamType;
    private Industry dummyIndustry;
    private TimeZone dummyTimeZone;
    private State dummyState;
    private Countries dummyCountry;
    private String dummyPostCode;
    private String dummyCity;
    private Boolean dummyHasClientSupport;
    private Boolean dummyManageOwnBilling;
    private String dummyStripeReference;
    private String dummyStripeSubscription;
    private String dummyStripeFixedSubItem;
    private String dummyStripeMeteredSubItem;
    private String dummyNameOnCard;
    private String dummyCardPostCode;
    private String dummyCardID;
    private Date dummyPlanRenewedOn;
    private Integer dummyUsedCredits;
    private Integer dummyAvailableCredits;
    private Boolean dummyIsPPJ;
    private Boolean dummyHasCap;
    private Integer dummyMaxCap;
    private Date dummyCouponExpiryDate;
    private Double dummyLastPlanAmount;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_HiringTeamName = DefaultAttributeHelper.INSTANCE;
    private static final BLOBAttributeHelper HELPER_HiringTeamLogo = BLOBAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_HiringTeamType = new EnumeratedAttributeHelper (HiringTeamType.FACTORY_HiringTeamType);
    private static final EnumeratedAttributeHelper HELPER_Industry = new EnumeratedAttributeHelper (Industry.FACTORY_Industry);
    private static final EnumeratedAttributeHelper HELPER_TimeZone = new EnumeratedAttributeHelper (TimeZone.FACTORY_TimeZone);
    private static final EnumeratedAttributeHelper HELPER_State = new EnumeratedAttributeHelper (State.FACTORY_State);
    private static final EnumeratedAttributeHelper HELPER_Country = new EnumeratedAttributeHelper (Countries.FACTORY_Countries);
    private static final DefaultAttributeHelper HELPER_PostCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_City = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_HasClientSupport = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ManageOwnBilling = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StripeReference = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StripeSubscription = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StripeFixedSubItem = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_StripeMeteredSubItem = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_NameOnCard = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CardPostCode = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CardID = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_PlanRenewedOn = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_UsedCredits = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_AvailableCredits = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsPPJ = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_HasCap = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_MaxCap = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CouponExpiryDate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LastPlanAmount = DefaultAttributeHelper.INSTANCE;
    



    public HiringTeamPersistenceMgr ()
    {
        dummyHiringTeamName = (String)(HELPER_HiringTeamName.initialise (dummyHiringTeamName));
        dummyHiringTeamLogo = (BinaryContent)(HELPER_HiringTeamLogo.initialise (dummyHiringTeamLogo));
        dummyHiringTeamType = (HiringTeamType)(HELPER_HiringTeamType.initialise (dummyHiringTeamType));
        dummyIndustry = (Industry)(HELPER_Industry.initialise (dummyIndustry));
        dummyTimeZone = (TimeZone)(HELPER_TimeZone.initialise (dummyTimeZone));
        dummyState = (State)(HELPER_State.initialise (dummyState));
        dummyCountry = (Countries)(HELPER_Country.initialise (dummyCountry));
        dummyPostCode = (String)(HELPER_PostCode.initialise (dummyPostCode));
        dummyCity = (String)(HELPER_City.initialise (dummyCity));
        dummyHasClientSupport = (Boolean)(HELPER_HasClientSupport.initialise (dummyHasClientSupport));
        dummyManageOwnBilling = (Boolean)(HELPER_ManageOwnBilling.initialise (dummyManageOwnBilling));
        dummyStripeReference = (String)(HELPER_StripeReference.initialise (dummyStripeReference));
        dummyStripeSubscription = (String)(HELPER_StripeSubscription.initialise (dummyStripeSubscription));
        dummyStripeFixedSubItem = (String)(HELPER_StripeFixedSubItem.initialise (dummyStripeFixedSubItem));
        dummyStripeMeteredSubItem = (String)(HELPER_StripeMeteredSubItem.initialise (dummyStripeMeteredSubItem));
        dummyNameOnCard = (String)(HELPER_NameOnCard.initialise (dummyNameOnCard));
        dummyCardPostCode = (String)(HELPER_CardPostCode.initialise (dummyCardPostCode));
        dummyCardID = (String)(HELPER_CardID.initialise (dummyCardID));
        dummyPlanRenewedOn = (Date)(HELPER_PlanRenewedOn.initialise (dummyPlanRenewedOn));
        dummyUsedCredits = (Integer)(HELPER_UsedCredits.initialise (dummyUsedCredits));
        dummyAvailableCredits = (Integer)(HELPER_AvailableCredits.initialise (dummyAvailableCredits));
        dummyIsPPJ = (Boolean)(HELPER_IsPPJ.initialise (dummyIsPPJ));
        dummyHasCap = (Boolean)(HELPER_HasCap.initialise (dummyHasCap));
        dummyMaxCap = (Integer)(HELPER_MaxCap.initialise (dummyMaxCap));
        dummyCouponExpiryDate = (Date)(HELPER_CouponExpiryDate.initialise (dummyCouponExpiryDate));
        dummyLastPlanAmount = (Double)(HELPER_LastPlanAmount.initialise (dummyLastPlanAmount));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_hiring_team.object_id as id, {PREFIX}tl_hiring_team.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_hiring_team.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_hiring_team.hiring_team_name, {PREFIX}tl_hiring_team.hiring_team_logo, {PREFIX}tl_hiring_team.hiring_team_type, {PREFIX}tl_hiring_team.industry, {PREFIX}tl_hiring_team.time_zone, {PREFIX}tl_hiring_team.state, {PREFIX}tl_hiring_team.country, {PREFIX}tl_hiring_team.post_code, {PREFIX}tl_hiring_team.city, {PREFIX}tl_hiring_team.has_client_support, {PREFIX}tl_hiring_team.manage_own_billing, {PREFIX}tl_hiring_team.stripe_reference, {PREFIX}tl_hiring_team.stripe_subscription, {PREFIX}tl_hiring_team.stripe_fixed_sub_item, {PREFIX}tl_hiring_team.stripe_metered_sub_item, {PREFIX}tl_hiring_team.name_on_card, {PREFIX}tl_hiring_team.card_post_code, {PREFIX}tl_hiring_team.card_id, {PREFIX}tl_hiring_team.plan_renewed_on, {PREFIX}tl_hiring_team.used_credits, {PREFIX}tl_hiring_team.available_credits, {PREFIX}tl_hiring_team.is_ppj, {PREFIX}tl_hiring_team.has_cap, {PREFIX}tl_hiring_team.max_cap, {PREFIX}tl_hiring_team.coupon_expiry_date, {PREFIX}tl_hiring_team.last_plan_amount, {PREFIX}tl_hiring_team.company_id, {PREFIX}tl_hiring_team.billing_team_id, {PREFIX}tl_hiring_team.added_by_user_id, {PREFIX}tl_hiring_team.payment_plan_id, {PREFIX}tl_hiring_team.coupon_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, HiringTeam.REFERENCE_HiringTeam);

                if (objectToReturn instanceof HiringTeam)
                {
                    LogMgr.log (HiringTeamPersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a HiringTeam");
                }
            }

            PersistentSet tl_hiring_teamPSet = allPSets.getPersistentSet(id, "tl_hiring_team", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_hiring_teamPSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_HiringTeamName)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_HiringTeamLogo)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_HiringTeamType)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_Industry)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_TimeZone)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_State)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_Country)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_PostCode)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_City)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_HasClientSupport)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_ManageOwnBilling)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_StripeReference)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_StripeSubscription)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_StripeFixedSubItem)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_StripeMeteredSubItem)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_NameOnCard)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_CardPostCode)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_CardID)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_PlanRenewedOn)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_UsedCredits)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_AvailableCredits)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_IsPPJ)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_HasCap)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_MaxCap)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_CouponExpiryDate)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.FIELD_LastPlanAmount)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.SINGLEREFERENCE_Company)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.SINGLEREFERENCE_BilledByTeam)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.SINGLEREFERENCE_AddedByUser)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.SINGLEREFERENCE_PaymentPlan)||
                    !tl_hiring_teamPSet.containsAttrib(HiringTeam.SINGLEREFERENCE_Coupon))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (HiringTeamPersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                HiringTeam result = new HiringTeam ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_hiring_team " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_hiring_team.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (HiringTeam.SINGLEREFERENCE_Company))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_hiring_team " +
                            "WHERE " + SELECT_JOINS + "company_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else if (refName.equals (HiringTeam.SINGLEREFERENCE_BilledByTeam))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_hiring_team " +
                            "WHERE " + SELECT_JOINS + "billing_team_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_hiring_teamPSet = allPSets.getPersistentSet(objectID, "tl_hiring_team");
            

            
            if (tl_hiring_teamPSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_hiring_teamPSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_hiring_team " +
                                                           "SET hiring_team_name = ?, hiring_team_logo = ?, hiring_team_type = ?, industry = ?, time_zone = ?, state = ?, country = ?, post_code = ?, city = ?, has_client_support = ?, manage_own_billing = ?, stripe_reference = ?, stripe_subscription = ?, stripe_fixed_sub_item = ?, stripe_metered_sub_item = ?, name_on_card = ?, card_post_code = ?, card_id = ?, plan_renewed_on = ?, used_credits = ?, available_credits = ?, is_ppj = ?, has_cap = ?, max_cap = ?, coupon_expiry_date = ?, last_plan_amount = ?, company_id = ? , billing_team_id = ? , added_by_user_id = ? , payment_plan_id = ? , coupon_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_hiring_team.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_HiringTeamName.getForSQL(dummyHiringTeamName, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HiringTeamName))).listEntry (HELPER_HiringTeamLogo.getForSQL(dummyHiringTeamLogo, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HiringTeamLogo))).listEntry (HELPER_HiringTeamType.getForSQL(dummyHiringTeamType, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HiringTeamType))).listEntry (HELPER_Industry.getForSQL(dummyIndustry, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_Industry))).listEntry (HELPER_TimeZone.getForSQL(dummyTimeZone, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_TimeZone))).listEntry (HELPER_State.getForSQL(dummyState, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_Country))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_PostCode))).listEntry (HELPER_City.getForSQL(dummyCity, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_City))).listEntry (HELPER_HasClientSupport.getForSQL(dummyHasClientSupport, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HasClientSupport))).listEntry (HELPER_ManageOwnBilling.getForSQL(dummyManageOwnBilling, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_ManageOwnBilling))).listEntry (HELPER_StripeReference.getForSQL(dummyStripeReference, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeReference))).listEntry (HELPER_StripeSubscription.getForSQL(dummyStripeSubscription, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeSubscription))).listEntry (HELPER_StripeFixedSubItem.getForSQL(dummyStripeFixedSubItem, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeFixedSubItem))).listEntry (HELPER_StripeMeteredSubItem.getForSQL(dummyStripeMeteredSubItem, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeMeteredSubItem))).listEntry (HELPER_NameOnCard.getForSQL(dummyNameOnCard, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_NameOnCard))).listEntry (HELPER_CardPostCode.getForSQL(dummyCardPostCode, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_CardPostCode))).listEntry (HELPER_CardID.getForSQL(dummyCardID, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_CardID))).listEntry (HELPER_PlanRenewedOn.getForSQL(dummyPlanRenewedOn, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_PlanRenewedOn))).listEntry (HELPER_UsedCredits.getForSQL(dummyUsedCredits, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_UsedCredits))).listEntry (HELPER_AvailableCredits.getForSQL(dummyAvailableCredits, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_AvailableCredits))).listEntry (HELPER_IsPPJ.getForSQL(dummyIsPPJ, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_IsPPJ))).listEntry (HELPER_HasCap.getForSQL(dummyHasCap, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HasCap))).listEntry (HELPER_MaxCap.getForSQL(dummyMaxCap, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_MaxCap))).listEntry (HELPER_CouponExpiryDate.getForSQL(dummyCouponExpiryDate, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_CouponExpiryDate))).listEntry (HELPER_LastPlanAmount.getForSQL(dummyLastPlanAmount, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_LastPlanAmount))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_Company)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_BilledByTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_AddedByUser)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_PaymentPlan)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_Coupon)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_hiring_team WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_hiring_team", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (HiringTeamPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_hiring_team");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_hiring_team for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (HiringTeamPersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_hiring_teamPSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (HiringTeamPersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_hiring_teamPSet = allPSets.getPersistentSet(objectID, "tl_hiring_team");
        

        LogMgr.log (HiringTeamPersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_hiring_teamPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_hiring_teamPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_hiring_team " +
                                                       "WHERE tl_hiring_team.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_hiring_team WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_hiring_team");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_hiring_team for row:" + objectID;

                    LogMgr.log (HiringTeamPersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_hiring_teamPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, HiringTeam> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (HiringTeam.REFERENCE_HiringTeam.getObjectIDSpace (), r.getLong ("id"));
            HiringTeam resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, HiringTeam.REFERENCE_HiringTeam);

                if (cachedElement instanceof HiringTeam)
                {
                    LogMgr.log (HiringTeamPersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (HiringTeam)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a HiringTeam");
                }
            }
            else
            {
                PersistentSet tl_hiring_teamPSet = allPSets.getPersistentSet(objectID, "tl_hiring_team", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new HiringTeam ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (HiringTeamPersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_hiring_team " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (HiringTeam.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_hiring_team.object_id is not null
                    String preFilter = "(tl_hiring_team.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_hiring_team " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_hiring_teamPSet = allPSets.getPersistentSet(objectID, "tl_hiring_team", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_hiring_teamPSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_hiring_teamPSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_HiringTeamName, HELPER_HiringTeamName.getFromRS(dummyHiringTeamName, r, "hiring_team_name"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_HiringTeamLogo, HELPER_HiringTeamLogo.getFromRS(dummyHiringTeamLogo, r, "hiring_team_logo"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_HiringTeamType, HELPER_HiringTeamType.getFromRS(dummyHiringTeamType, r, "hiring_team_type"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_Industry, HELPER_Industry.getFromRS(dummyIndustry, r, "industry"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_TimeZone, HELPER_TimeZone.getFromRS(dummyTimeZone, r, "time_zone"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_State, HELPER_State.getFromRS(dummyState, r, "state"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_Country, HELPER_Country.getFromRS(dummyCountry, r, "country"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_PostCode, HELPER_PostCode.getFromRS(dummyPostCode, r, "post_code"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_City, HELPER_City.getFromRS(dummyCity, r, "city"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_HasClientSupport, HELPER_HasClientSupport.getFromRS(dummyHasClientSupport, r, "has_client_support"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_ManageOwnBilling, HELPER_ManageOwnBilling.getFromRS(dummyManageOwnBilling, r, "manage_own_billing"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_StripeReference, HELPER_StripeReference.getFromRS(dummyStripeReference, r, "stripe_reference"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_StripeSubscription, HELPER_StripeSubscription.getFromRS(dummyStripeSubscription, r, "stripe_subscription"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_StripeFixedSubItem, HELPER_StripeFixedSubItem.getFromRS(dummyStripeFixedSubItem, r, "stripe_fixed_sub_item"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_StripeMeteredSubItem, HELPER_StripeMeteredSubItem.getFromRS(dummyStripeMeteredSubItem, r, "stripe_metered_sub_item"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_NameOnCard, HELPER_NameOnCard.getFromRS(dummyNameOnCard, r, "name_on_card"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_CardPostCode, HELPER_CardPostCode.getFromRS(dummyCardPostCode, r, "card_post_code"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_CardID, HELPER_CardID.getFromRS(dummyCardID, r, "card_id"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_PlanRenewedOn, HELPER_PlanRenewedOn.getFromRS(dummyPlanRenewedOn, r, "plan_renewed_on"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_UsedCredits, HELPER_UsedCredits.getFromRS(dummyUsedCredits, r, "used_credits"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_AvailableCredits, HELPER_AvailableCredits.getFromRS(dummyAvailableCredits, r, "available_credits"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_IsPPJ, HELPER_IsPPJ.getFromRS(dummyIsPPJ, r, "is_ppj"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_HasCap, HELPER_HasCap.getFromRS(dummyHasCap, r, "has_cap"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_MaxCap, HELPER_MaxCap.getFromRS(dummyMaxCap, r, "max_cap"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_CouponExpiryDate, HELPER_CouponExpiryDate.getFromRS(dummyCouponExpiryDate, r, "coupon_expiry_date"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.FIELD_LastPlanAmount, HELPER_LastPlanAmount.getFromRS(dummyLastPlanAmount, r, "last_plan_amount"));
        
        tl_hiring_teamPSet.setAttrib(HiringTeam.SINGLEREFERENCE_Company, r.getObject ("company_id"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.SINGLEREFERENCE_BilledByTeam, r.getObject ("billing_team_id"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.SINGLEREFERENCE_AddedByUser, r.getObject ("added_by_user_id"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.SINGLEREFERENCE_PaymentPlan, r.getObject ("payment_plan_id"));
        tl_hiring_teamPSet.setAttrib(HiringTeam.SINGLEREFERENCE_Coupon, r.getObject ("coupon_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_hiring_teamPSet = allPSets.getPersistentSet(objectID, "tl_hiring_team");
        

        
        if (tl_hiring_teamPSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_hiring_teamPSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_hiring_team " +
                                     "  (hiring_team_name, hiring_team_logo, hiring_team_type, industry, time_zone, state, country, post_code, city, has_client_support, manage_own_billing, stripe_reference, stripe_subscription, stripe_fixed_sub_item, stripe_metered_sub_item, name_on_card, card_post_code, card_id, plan_renewed_on, used_credits, available_credits, is_ppj, has_cap, max_cap, coupon_expiry_date, last_plan_amount,  company_id, billing_team_id, added_by_user_id, payment_plan_id, coupon_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_HiringTeamName.getForSQL(dummyHiringTeamName, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HiringTeamName))).listEntry (HELPER_HiringTeamLogo.getForSQL(dummyHiringTeamLogo, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HiringTeamLogo))).listEntry (HELPER_HiringTeamType.getForSQL(dummyHiringTeamType, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HiringTeamType))).listEntry (HELPER_Industry.getForSQL(dummyIndustry, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_Industry))).listEntry (HELPER_TimeZone.getForSQL(dummyTimeZone, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_TimeZone))).listEntry (HELPER_State.getForSQL(dummyState, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_State))).listEntry (HELPER_Country.getForSQL(dummyCountry, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_Country))).listEntry (HELPER_PostCode.getForSQL(dummyPostCode, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_PostCode))).listEntry (HELPER_City.getForSQL(dummyCity, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_City))).listEntry (HELPER_HasClientSupport.getForSQL(dummyHasClientSupport, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HasClientSupport))).listEntry (HELPER_ManageOwnBilling.getForSQL(dummyManageOwnBilling, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_ManageOwnBilling))).listEntry (HELPER_StripeReference.getForSQL(dummyStripeReference, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeReference))).listEntry (HELPER_StripeSubscription.getForSQL(dummyStripeSubscription, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeSubscription))).listEntry (HELPER_StripeFixedSubItem.getForSQL(dummyStripeFixedSubItem, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeFixedSubItem))).listEntry (HELPER_StripeMeteredSubItem.getForSQL(dummyStripeMeteredSubItem, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_StripeMeteredSubItem))).listEntry (HELPER_NameOnCard.getForSQL(dummyNameOnCard, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_NameOnCard))).listEntry (HELPER_CardPostCode.getForSQL(dummyCardPostCode, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_CardPostCode))).listEntry (HELPER_CardID.getForSQL(dummyCardID, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_CardID))).listEntry (HELPER_PlanRenewedOn.getForSQL(dummyPlanRenewedOn, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_PlanRenewedOn))).listEntry (HELPER_UsedCredits.getForSQL(dummyUsedCredits, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_UsedCredits))).listEntry (HELPER_AvailableCredits.getForSQL(dummyAvailableCredits, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_AvailableCredits))).listEntry (HELPER_IsPPJ.getForSQL(dummyIsPPJ, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_IsPPJ))).listEntry (HELPER_HasCap.getForSQL(dummyHasCap, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_HasCap))).listEntry (HELPER_MaxCap.getForSQL(dummyMaxCap, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_MaxCap))).listEntry (HELPER_CouponExpiryDate.getForSQL(dummyCouponExpiryDate, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_CouponExpiryDate))).listEntry (HELPER_LastPlanAmount.getForSQL(dummyLastPlanAmount, tl_hiring_teamPSet.getAttrib (HiringTeam.FIELD_LastPlanAmount))) .listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_Company)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_BilledByTeam)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_AddedByUser)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_PaymentPlan)))).listEntry (SQLManager.CheckNull((Long)(tl_hiring_teamPSet.getAttrib (HiringTeam.SINGLEREFERENCE_Coupon)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_hiring_teamPSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
