<%@ page extends="oneit.servlets.jsp.FormJSP" %>

<%@ include file="/setuprequest.jsp" %>
<%@ include file="inc/stdimports.jsp" %>
<%@ include file="/editor/stdimports.jsp" %>

<%@ page import="oneit.business.content.editor.gui.*" %>

<%! protected String getName (ServletConfig config) { return "editNotificationTemplate_jsp"; } %>
<%
    ORMProcessState         process                 =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran                 =   process.getTransaction ();
    boolean                 toRedirect              =   GenericObjDF.getOrCreateObject (request, "NotificationTemplate", NotificationTemplate.REFERENCE_NotificationTemplate);
    NotificationTemplate    notificationTemplate    =   (NotificationTemplate) process.getAttribute("NotificationTemplate");
    
    if (toRedirect)
    {
        %><%@include file="/saferedirect.jsp"%><%
    }

    Debug.assertion(notificationTemplate != null, "NotificationTemplate is null in Edit Notification Template", "404");
    
    String  continuePage    =   "editNotificationTemplate.jsp?NotificationTemplateID=" + notificationTemplate.getObjectID();

    request.setAttribute("oneit.pageFormDetails", CollectionUtils.mapEntry("name", "NotificationTemplate").mapEntry("enctype", "multipart/form-data").toMap());
    request.setAttribute("oneit.pageHeaderTitle", "Notification Template");
%>

<%@include file="/editor/header.jsp" %>


<oneit:layout_total widths="<%= new double[] {2, 6, 4} %>" skin="bootstrap">

    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel obj="<%= notificationTemplate %>"    field="DaysAfter"/>
        </oneit:layout_label>
        <oneit:layout_field width="1">
            <oneit:ormInput obj="<%= notificationTemplate %>"    attributeName="DaysAfter"/>
        </oneit:layout_field>
    </oneit:skin>
                    
    <oneit:skin tagName="layout_row">
        <oneit:layout_label width="1">
            <oneit:ormlabel     obj="<%= notificationTemplate %>"    field="NotificationContent"/>
        </oneit:layout_label>
        <oneit:layout_field width="1">
            <tagfile:htmleditor obj="<%= notificationTemplate %>"    attribName="NotificationContent" id="texteditor"
                    toolbarSet="<%= EditorGUIOptions.Default %>"/> 
        </oneit:layout_field>
    </oneit:skin>

</oneit:layout_total>
<div    class="bottomButtons"   hidden="true">

    <oneit:button   value="Save"            name="save" cssClass="BUTTON_PRIMARY"           
                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "listNotificationTemplates.jsp").toMap() %>"/>
                                    
    <oneit:button   value="Cancel"          name="cancel"   cssClass="BUTTON_SECONDARY"     showIfReadOnly="true"
                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", "listNotificationTemplates.jsp")
                                                    .mapEntry (UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                    .toMap() %>"/>
</div>

<%@include file="/editor/footer.jsp" %>