<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState 	process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction 	objTran         =   process.getTransaction();
    Job                 job             =   (Job) process.getAttribute("Job");
    JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Candidate           candidate       =   jobApplication.getCandidate();

%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                <%
                    }
                %>
            </div>
            <div>
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
            </div>
            <div>
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>
        </div>
        <div>
            <div class="main-appli-name">
                <div class="appli-name"><oneit:toString value="<%= candidate.getToString() %>"  mode="EscapeHTML"/></div>
                <div class="appli-applied">
                    Applied <oneit:toString  value="<%= jobApplication.getSubmittedDate() %>"   mode="MidDate"/>
                </div>
            </div>
            <div>
                shortlisted
            </div>
            <div>
                <div class="overall-suit">
                    overall rank
                    <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
                </div>
            </div>
            <div class="contact-label">E
                <a href="<%= "mailto:" + candidate.getUser().getUserName() %>">
                    <oneit:toString value="<%= candidate.getUser().getUserName() %>" mode="EscapeHTML" />
                </a>
            </div>
            <div class="contact-row">
                <div class="contact-label">P
                    <oneit:toString value="<%= candidate.getPhone() %>" mode="EscapeHTML" />
                </div>
            </div>
                
            <!--Requirements-->   
            <%
                if(job.getIncludeAssessmentCriteria() == Boolean.TRUE)
                {
            %>   
                    <table width="100%" cellspacing="0" cellpadding="0" style="margin-top:10px;">
                        <tr>
                            <td style="width:30%;">
                                <div>Requirements</div>
                                <div>
                                    <img src="file:///<%= jobApplication.getRequirementRingChart() %>" alt="Ring Chart"/>
                                </div>
                            </td>
                            <td>
                                <table width="100%" cellspacing="0" cellpadding="0">
                                    <%
                                        Map<Importance, Long>   requirementFitData  =   (Map<Importance, Long>)jobApplication.getRequirementFit();

                                        for(Importance importance: Utils.getImportancesForAssessment())
                                        {
                                            Long    rating  =   requirementFitData.get(importance);            
                                    %>
                                            <tr>
                                                <span class="appli-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></span>
                                                <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                                <span class="appli-progress-bar">
                                                    <div class="progress">
                                                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>;"></div>
                                                    </div>
                                                </span>
                                            </tr>
                                    <%
                                        }
                                    %>
                                </table>
                            </td>
                        </tr>
                    </table>
            <%
                }
            %>   
            
            <!--Role Fit-->   
            <table width="100%" cellspacing="0" cellpadding="0" style="margin-top:10px;">
                <tr>
                    <td style="width:30%;">
                        <div>Role Fit</div>
                        <div>
                            <img src="file:///<%= jobApplication.getRoleFitChart() %>" alt="Ring Chart"/>
                        </div>
                    </td>
                    <td>
                        <table width="100%" cellspacing="0" cellpadding="0">
                            <%
                                Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>   roleScoreMap    =   (Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>)jobApplication.getRoleFit();
                                Map<FactorClass, Map<FactorLevelLink, Map>>             factorClassDtls =   (Map<FactorClass, Map<FactorLevelLink, Map>>) jobApplication.getFactorScoreDetails();
                            
                                for(FactorClass factorClass : factorClassDtls.keySet())
                                {
                                    Double  rating  =   roleScoreMap.get(factorClass).get2();
                            %>
                                    <tr>
                                        <span class="appli-label"><oneit:toString   value="<%= factorClass %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>;"></div>
                                            </div>
                                        </span>
                                    </tr>
                            <%
                                }
                            %>
                        </table>
                    </td>
                </tr>
            </table>
            
            <!--Culture Fit Data-->
            <table width="100%" cellspacing="0" cellpadding="0" style="margin-top:10px;">
                <tr>
                    <td style="width:30%;">
                        <div>Culture Fit</div>
                        <div>
                            <img src="file:///<%= jobApplication.getCultureRingChart() %>" alt="Ring Chart"/>
                        </div>
                    </td>
                    <td>
                        <table width="100%" cellspacing="0" cellpadding="0">
                            <%
                                Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>    cultureFitData  =   (Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>) jobApplication.getCultureFit();
                            
                                for(CultureClass cClass: cultureFitData.keySet())
                                {
                                    if(cClass == null || cultureFitData.get(cClass) == null)
                                    {
                                        continue;
                                    }
                                
                                    Long    rating  =   cultureFitData.get(cClass).get0();
                            %>
                                    <tr>
                                        <span class="appli-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>;"></div>
                                            </div>
                                        </span>
                                    </tr>
                            <%
                                }
                            %>
                        </table>
                    </td>
                </tr>
            </table>
                        
        </div>        
                
            
    </div>
</oneit:dynIncluded>