import { Component, OnInit, OnDestroy, ViewChild } from '@angular/core';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { NgForm } from '@angular/forms';
import { Subscription } from 'rxjs/Subscription';

import { Message, MenuItem } from 'primeng/primeng';

import { AppService } from './../../app.service';
import { UtilsService } from './../../oneit/services/utils.service';
import { SaveService } from './../../oneit/services/save.service';
import { EditMessageTemplateService } from './edit-message-template.service';

import { MessageTemplate } from './edit-message-template.model';

@Component({
    selector: 'app-edit-message-template',
    templateUrl: './edit-message-template.component.html'
})
export class EditMessageTemplateComponent implements OnInit, OnDestroy {
    
    subscriptions: Array<Subscription> = [];
    @ViewChild('form') form: NgForm;
    createdObjs =   {};
    updatedObjs =   {};
    deletedObjs =   {};

    messageTemplate = new MessageTemplate();
    messageTemplateTypes: any[] = [];
    showLoader: boolean = false;
    
    constructor(
        private router: Router,
        private activatedRoute: ActivatedRoute,
        private utilsService: UtilsService,
        private saveService: SaveService,
        private appService: AppService,
        private editMessageTemplateService: EditMessageTemplateService
    ){
        
    }

    ngOnInit() {

        this.utilsService.resetCounter();
        
        this.subscriptions.push(this.activatedRoute.params
            .subscribe(
                (params: Params) => {
                    this.showLoader = true;
                    if (params.id && params.id !== '0') {
                        this.getMessageTemplateByID(params.id);
                    } else {
                        this.utilsService.createObject(this.messageTemplate, this.createdObjs);
                        this.showLoader = false;
                    }
                }
        ));
        this.getMessageTemplateTypes();
    }
    

    getMessageTemplateTypes() {
        this.subscriptions.push(this.editMessageTemplateService.getMessageTemplateTypes([])
            .subscribe(
                data => {
                    this.messageTemplateTypes = data;
                },
                error => {
                    this.utilsService.handleError(error);
                }
            )
        );
    }

    getMessageTemplateByID(id) {
        
        this.showLoader = true;
        this.createdObjs = {};
        this.updatedObjs = {};
        this.deletedObjs = {};
        this.utilsService.resetCounter();
        this.utilsService.clearErrorMessages();
        
        let assocs  =   [];
        this.subscriptions.push(this.editMessageTemplateService.getMessageTemplateByID(id, assocs)
            .subscribe(
                data => {
                    this.messageTemplate = data;
                    this.updatedObjs[this.messageTemplate.ObjectID] = this.messageTemplate;

                    //Loop over other multirefs here, which can be updated on screen e.g

                    this.showLoader = false;
                },
                error => {
                    this.showLoader = false;
                    this.utilsService.handleError(error);
                }
            )
        );
    }
    
    saveMessageTemplate(reload: boolean) {
        this.utilsService.clearErrorMessages();
        
        if (this.form.invalid) {
            this.utilsService.showAllErrorMessages();
        } else {
            this.showLoader = true;
            this.subscriptions.push(this.saveService.saveObjectsWithDefaultSvc(this.createdObjs, this.updatedObjs, this.deletedObjs)
                .subscribe(
                    data => {
                        this.utilsService.handleSuccess();
                        if (reload) {
                            let idToNavigate = this.messageTemplate.ObjectID;
                            if (data["created"][idToNavigate]) {
                                idToNavigate = data["created"][idToNavigate];
                                this.router.navigate(["/admin/edit-message-template", idToNavigate]);
                                return;
                            }
                            this.getMessageTemplateByID(idToNavigate);
                        }
                        else {
                            this.router.navigate([""]);
                        }
                    },
                    error => {
                        this.showLoader = false;
                        this.utilsService.handleError(error);
                    }
                )
            );
        }
    }
    
    ngOnDestroy(){
        this.utilsService.unsubscribeSubscriptions(this.subscriptions);
    }
}
