<%@page import="performa.orm.types.StageType"%>
<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%
    Job[]           jobs            =   (Job[]) getData(request, "Jobs");
    JobStatus       jobStatus       =   (JobStatus) getData(request, "JobStatus"); 
    JobSortOption   jobSortOption   =   (JobSortOption) getData(request, "JobSortOption"); 
    String          nextPage        =   (String)  getData(request, "NextPage");
    String          homePage        =   (String)  getData(request, "HomePage");
    String          shortlistPage   =   (String)  getData(request, "ShortlistPage");
    boolean         canCreateJob    =   (boolean) getData(request, "CanCreateJob");
    CompanyUser     compUser        =   (CompanyUser) getData(request, "CompanyUser");
%>

<oneit:dynIncluded>
    
    <script type="text/javascript">
        var ExtendPopup     =   null;
        var StatusPopup     =   null;
        var ConfirmPopup    =   null;

        $(document).ready(function() 
        {
            $('.conic-circle').percentageLoader({		
                valElement: 'p',		
                strokeWidth: 6,		
                bgColor: '#e5e8eb',		
                ringColor: '#03a0e7',		
                textColor: '#03a0e7',		
                fontSize: '0px',		
                fontWeight: 'normal'		
            });
            
            ExtendPopup = new jBox('Modal', {
                id : "extend-job",
                overlay : true, 
                width : 500, height : 400
            });
            
            StatusPopup = new jBox('Modal', {
                id : "status-change",
                overlay : true, 
                width : 500, height : 280
            });
            
            ConfirmPopup = new jBox('Modal', {
                id : "status-change-confirm",
                overlay : true, 
                width : 500, height : 350
            });
                  
            $(".job-status").change(function()
            {
                var id  = $(this).closest('.job-list').attr('id');
                $('.save-job' + id).click();
            });
            
            $(".change-plan-no-button").on("click",function(){             
                ExtendPopup.close();
            });
            
            $(".first-confirm-no-button").on("click",function(){             
                StatusPopup.close();
            });
            
            $(".second-confirm-no-button").on("click",function(){             
                ConfirmPopup.close();
            });
        });
        
        function showExtendPopup(elem)
        {
            ExtendPopup.setContent($("#" + $(elem).data('popupid')  ));
            ExtendPopup.open();
        }
        
        function showStatusPopup(elemid)
        {
            StatusPopup.setContent($("#status-change-" + elemid  ));
            StatusPopup.open();
        }
        
        function showStatusConfirmPopup(elemid)
        {
            StatusPopup.close();
            ConfirmPopup.setContent($("#status-change-confirm-" + elemid  ));
            ConfirmPopup.open();
        }
    </script>
    <style>
        .calendar .extend-icon{
            margin: 0 5px 0 10px;
        }
        .calendar .extend-btn{
            color: #03A0E7;
        }
        .calendar .extend-span{
            cursor: pointer;
        }
        .extend-job-content{
           padding: 10px 40px; 
        }
        .extend-job-content h3{
            color: #4A4A4A;	
            font-size: 22px;	
            font-weight: 500;	
            line-height: 29px;
            font-family: "Usual-Medium";
        }
        .extend-job-content .extend-job-info{
            color: #4A4A4A;	
            font-family: "Usual-Light";	
            font-size: 16px;	
            font-weight: 300;	
            line-height: 25px;	
            padding-top: 10px;
        }
        .extend-job-content .password-text{
            padding: 10px 0 10px;
            font-size: 16px;	
            font-weight: 300;	
            line-height: 25px;
        }
        .extend-job-button {
            padding-bottom: 0px;
        }
        
    </style>
    <div class="main-job-list">
        <oneit:button   skin="link" value=" " name="extendJob"    cssClass="hide"
                                                                requestAttribs="<%=  CollectionUtils.EMPTY_MAP %>" />
    <%
        ObjectTransaction   objTran     =   process.getTransaction ();
        CompanyUser         companyUser =   SecUser.getTXUser(objTran).getExtension(CompanyUser.REFERENCE_CompanyUser);
        RoleType            roleType    =   companyUser.pipelineCompanyUser().toHiringTeams(CompanyUserHiringTeamLink.SearchByAll().andHiringTeam(new EqualsFilter<>(companyUser.getSelectedTeam()))).toRole().val();
        
        for(Job job: jobs)
        {
            int     shortlisted     =   job.getNoOfCandidatesFor(job.getWorkFlowByStageType(StageType.SUCCESSFUL));
            int     maxShortlist    =   job.getMaxShortlistApplicants();
            String  editJobPage     =   nextPage;
            
            // go to edit job if job is in draft status
            if(job.getJobStatus() == JobStatus.DRAFT)
            {
                Article jobsArticle =   WebUtils.getArticleByShortCut(transaction, WebUtils.JOBS);

                if(job.getDraftLocation() == null)
                {
                    editJobPage =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.JOB_REVIEW).toMap());
                }
                else if(job.getDraftLocation() == DraftLocation.DETAILS)
                {
                    editJobPage =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.CREATE_JOB).toMap());
                }
                else if(job.getDraftLocation() == DraftLocation.ASSESSMENT)
                {
                    editJobPage =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.ASSESSMENT_CRITERIA).toMap());
                }
                else if(job.getDraftLocation() == DraftLocation.CULTURE)
                {
                    editJobPage =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.WORKPLACE_CULTURE).toMap());
                }
                else if(job.getDraftLocation() == DraftLocation.REVIEW)
                {
                    editJobPage =   jobsArticle.getLink(request, CollectionUtils.mapEntry("cms.rm", WebUtils.JOB_REVIEW).toMap());
                }

                editJobPage    =   editJobPage + "&JobID=" + job.getObjectID();  
            }
    %>
            <div class="job-list"   id="<%= job.getID() %>">
                <div class="job-row"   >
                    <div class="job-post jl-c eq-second-height" style="height: 107px;">
                        <div class="job-post-name">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", editJobPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>">
                                    <oneit:toString value="<%= job.getJobTitle() %>" mode="EscapeHTML" />
                                <%
                                    if(job.getReferenceNumber() != null)
                                    {
                                %>
                                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                                <%
                                    }
                                %>
                            </oneit:button>
                        </div>
                        <div class="job-company-name">
                            <span class="superlaw">
                                <%
                                    if(job.isClientAvailable())
                                    {
                                %>
                                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                                <%
                                    }
                                %>
                            </span>
                            <span class="calendar">
                                <%
                                    if(job.getJobStatus() == JobStatus.OPEN)
                                    {
                                        int daysToClose =   job.getNoOfDaystoClosed();
                                %>
                                        <span class="extend-span" data-popupid ="extend-job-<%=job.getID()%>"   onclick="<%= canCreateJob ? "showExtendPopup(this)" : "showReachedCap()" %>">
                                            <span class="number">
                                                <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                                            </span>
                                            <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                                            <img class="extend-icon"    src="images/icon-extend.svg"/> <a class="extend-btn">Extend</a>
                                        </span>
                                        <div id="extend-job-<%= job.getID() %>" style="display:none" >
                                            <div class="extend-job-content">
                                                <h3>
                                                    Are you sure you want to extend this job?
                                                </h3>
                                                <div class="extend-job-info">
                                                    There is a charge equal to 1 Job to extend a job.<br/><br/>
                                                    Extending this Job will add an additional 30 days for applicants to apply. By confirming the new close date for this job will be 
                                                    <oneit:toString value="<%= DateDiff.add(job.getApplyBy(), Calendar.DATE, 30) %>" mode="LongDate" />.
                                                    Would you like to continue?
                                                </div>
                                            </div>
                                            <div class="change-plan-button extend-job-button">
                                                <a class="change-plan-no-button popup-no-button">No</a>
                                                <oneit:button   skin="link" value="Yes"     name="extendJob"    cssClass="change-plan-yes-button"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage)
                                                                                            .mapEntry("Job", job)
                                                                                            .mapEntry("CompanyUser", compUser)
                                                                                            .toMap() %>" />

                                            </div>
                                        </div> 
                                <%
                                    }
                                    else
                                    {
                                %>
                                        <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                                        <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                                <%
                                    }
                                %>
                            </span>
                        </div>
                    </div>
                    <div class="job-application jl-c eq-second-height" style="height: 107px;">
                        <div class="ja-icon"><img src="images/job-list-user.svg"></div>
                        <div class="ja-count">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                            .toMap() %>"    disabled="<%= job.getJobStatus() == JobStatus.DRAFT ? "true" : "false" %>">
                                <oneit:toString value="<%= job.getNoOfCandidatesApplied() %>"   mode="EscapeHTML"   nullValue="0"/>
                            </oneit:button>
                            <span class="grey-span">Applicants</span>
                        </div>
                    </div>
                    <div class="job-shortlisted jl-c eq-second-height" style="height: 107px;">
                        <div class="ja-icon">
                            <div class="conic-circle">
                                <p style="display:none;">
                                    <oneit:toString value="<%= shortlisted * (100 / maxShortlist) %>"   mode="PercentageWholeNumber" />
                                </p>
                                <%
                                    if(shortlisted == maxShortlist)
                                    {
                                %>
                                        <img src="images/stroke-3.svg" class="right-mark-img" />
                                <%
                                    }
                                %>
                            </div>
                        </div>
                        <div class="ja-count">
                            <oneit:button   value=" "   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).mapEntry("ApplicationStatus", StageType.INTERVIEW).toMap())
                                                                            .toMap() %>"    disabled="<%= job.getJobStatus() == JobStatus.DRAFT ? "true" : "false" %>">
                                <oneit:toString value="<%= shortlisted %>"  mode="Integer"  nullValue="0"/>
                            </oneit:button>
                            /
                            <oneit:toString value="<%= maxShortlist %>" mode="Integer"  nullValue="0"/>
                            <span class="grey-span">successful</span>
                        </div>
                    </div>
                </div>
                <div class="job-states jl-c wider-select">
                    <div class="dropdown show select2type">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink<%= job.getID() %>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="top-selected-item"><img src="images/<%= job.getJobStatus().getDescription().toLowerCase() %>.png" class="userPic" /> <%= job.getJobStatus().getDescription() %></span>
                            <span class="select2type_arrow " role="presentation"><b role="presentation"></b></span>
                        </a>
                        <div class="dropdown-menu select2type-results"  aria-labelledby="dropdownMenuLink<%= job.getID() %>">
                            <a href="#" class="dropdown-item icontype_<%= job.getJobStatus().getDescription().toLowerCase() %>"><%= job.getJobStatus().getDescription() %></a>
                        <%
                            for (JobStatus jStatus : job.getAvailableStatus(roleType))
                            {
                        %>
                                <a class="<%="dropdown-item icontype_" + jStatus.getDescription().toLowerCase() %>" onClick="showStatusPopup('<%= job.getID().toString() + jStatus %>')">
                                    <%= jStatus.getDescription() %>
                                </a>
                                <div id="status-change-<%= job.getID().toString() + jStatus %>" style="display:none" >
                                    <div class="extend-job-content">
                                        <h3>
                                            Are you sure you want to change the status of this job?
                                        </h3>
                                    </div>
                                    <div class="change-plan-button extend-job-button">
                                        <a class="first-confirm-no-button popup-no-button">No</a>
                                        <%
                                            if(jStatus ==  JobStatus.OPEN)
                                            {
                                        %>
                                                <oneit:button   skin="link" value="Yes"     name="saveJob"    cssClass="change-plan-yes-button"
                                                                requestAttribs="<%= CollectionUtils.mapEntry("Job", job)
                                                                                                    .mapEntry("nextPage", homePage + "&JobStatus=" + (jobStatus != null ? jobStatus : "") + "&JobSortOption=" + jobSortOption)
                                                                                                    .mapEntry("JobStatus", jStatus)
                                                                                                    .toMap() %>" />
                                        <%
                                            }
                                            else
                                            {
                                        %>
                                                <a class=" change-plan-yes-button" onclick="showStatusConfirmPopup('<%= job.getID().toString() + jStatus %>')">Yes</a>
                                        <%
                                            }
                                        %>
                                    </div>
                                </div> 
                                <div id="status-change-confirm-<%= job.getID().toString() + jStatus %>" style="display:none" >
                                    <div class="extend-job-content">
                                        <h3>
                                            Are you sure you want to change the status of this job?
                                        </h3>
                                        <div class="extend-job-info">
                                            By changing this job to Closed or Filled no further applicants can be accepted and the Job can not be reopened. Do you with to continue?
                                        </div>
                                    </div>
                                    <div class="change-plan-button extend-job-button">
                                        <a class="second-confirm-no-button popup-no-button">No</a>
                                        <oneit:button   skin="link" value="Yes"     name="saveJob"    cssClass="change-plan-yes-button"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("Job", job)
                                                                                            .mapEntry("nextPage", homePage + "&JobStatus=" + (jobStatus != null ? jobStatus : "") + "&JobSortOption=" + jobSortOption)
                                                                                            .mapEntry("JobStatus", jStatus)
                                                                                            .toMap() %>" />
                                    </div>
                                </div> 
                        <%
                            }
                        %>
                        </div>
                    </div>
                </div>
            </div>
    <%
        }
    %>

    </div>
</oneit:dynIncluded>

