/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.ApplicationFee;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.Card;
import com.stripe.model.ChargeCollection;
import com.stripe.model.ChargeRefundCollection;
import com.stripe.model.Customer;
import com.stripe.model.Dispute;
import com.stripe.model.ExpandableField;
import com.stripe.model.ExternalAccount;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.Order;
import com.stripe.model.Review;
import com.stripe.model.ShippingDetails;
import com.stripe.model.StripeObject;
import com.stripe.model.Transfer;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Charge
extends ApiResource
implements MetadataStore<Charge>,
HasId {
    public static final String FRAUD_DETAILS = "fraud_details";
    String id;
    String object;
    Long amount;
    Long amountRefunded;
    ExpandableField<Application> application;
    ExpandableField<ApplicationFee> applicationFee;
    AlternateStatementDescriptors alternateStatementDescriptors;
    ExpandableField<BalanceTransaction> balanceTransaction;
    Boolean captured;
    Long created;
    String currency;
    ExpandableField<Customer> customer;
    String description;
    ExpandableField<Account> destination;
    ExpandableField<Dispute> dispute;
    String failureCode;
    String failureMessage;
    FraudDetails fraudDetails;
    ExpandableField<Invoice> invoice;
    Level3 level3;
    Boolean livemode;
    Map<String, String> metadata;
    ExpandableField<Account> onBehalfOf;
    ExpandableField<Order> order;
    Outcome outcome;
    Boolean paid;
    String receiptEmail;
    String receiptNumber;
    Boolean refunded;
    ChargeRefundCollection refunds;
    ExpandableField<Review> review;
    ShippingDetails shipping;
    ExternalAccount source;
    ExpandableField<Transfer> sourceTransfer;
    String statementDescriptor;
    String status;
    ExpandableField<Transfer> transfer;
    String transferGroup;
    String authorizationCode;
    @Deprecated
    Card card;
    @Deprecated
    Boolean disputed;
    @Deprecated
    String statementDescription;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String applicationId) {
        this.application = Charge.setExpandableFieldId(applicationId, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application c) {
        this.application = new ExpandableField<Application>(c.getId(), c);
    }

    public String getApplicationFee() {
        return this.applicationFee != null ? this.applicationFee.getId() : null;
    }

    public void setApplicationFee(String applicationFeeId) {
        this.applicationFee = Charge.setExpandableFieldId(applicationFeeId, this.applicationFee);
    }

    public ApplicationFee getApplicationFeeObject() {
        return this.applicationFee != null ? this.applicationFee.getExpanded() : null;
    }

    public void setApplicationFeeObject(ApplicationFee c) {
        this.applicationFee = new ExpandableField<ApplicationFee>(c.getId(), c);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String balanceTransactionId) {
        this.balanceTransaction = Charge.setExpandableFieldId(balanceTransactionId, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction c) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerId) {
        this.customer = Charge.setExpandableFieldId(customerId, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer c) {
        this.customer = new ExpandableField<Customer>(c.getId(), c);
    }

    public String getDestination() {
        return this.destination != null ? this.destination.getId() : null;
    }

    public void setDestination(String destinationId) {
        this.destination = ApiResource.setExpandableFieldId(destinationId, this.destination);
    }

    public Account getDestinationObject() {
        return this.destination != null ? this.destination.getExpanded() : null;
    }

    public void setDestinationObject(Account c) {
        this.destination = new ExpandableField<Account>(c.getId(), c);
    }

    public String getDispute() {
        return this.dispute != null ? this.dispute.getId() : null;
    }

    public void setDispute(String disputeId) {
        this.dispute = Charge.setExpandableFieldId(disputeId, this.dispute);
    }

    public Dispute getDisputeObject() {
        return this.dispute != null ? this.dispute.getExpanded() : null;
    }

    public void setDisputeObject(Dispute dispute) {
        this.dispute = new ExpandableField<Dispute>(dispute.getId(), dispute);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String invoiceId) {
        this.invoice = Charge.setExpandableFieldId(invoiceId, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice c) {
        this.invoice = new ExpandableField<Invoice>(c.getId(), c);
    }

    public String getOnBehalfOf() {
        return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
    }

    public void setOnBehalfOf(String onBehalfOfId) {
        this.onBehalfOf = ApiResource.setExpandableFieldId(onBehalfOfId, this.onBehalfOf);
    }

    public Account getOnBehalfOfObject() {
        return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
    }

    public void setOnBehalfOfObject(Account c) {
        this.onBehalfOf = new ExpandableField<Account>(c.getId(), c);
    }

    public String getOrder() {
        return this.order != null ? this.order.getId() : null;
    }

    public void setOrder(String orderId) {
        this.order = Charge.setExpandableFieldId(orderId, this.order);
    }

    public Order getOrderObject() {
        return this.order != null ? this.order.getExpanded() : null;
    }

    public void setOrderObject(Order c) {
        this.order = new ExpandableField<Order>(c.getId(), c);
    }

    public ChargeRefundCollection getRefunds() {
        if (this.refunds != null && this.refunds.getUrl() == null) {
            this.refunds.setUrl(String.format("/v1/charges/%s/refunds", this.getId()));
        }
        return this.refunds;
    }

    public String getReview() {
        return this.review != null ? this.review.getId() : null;
    }

    public void setReview(String reviewId) {
        this.review = Charge.setExpandableFieldId(reviewId, this.review);
    }

    public Review getReviewObject() {
        return this.review != null ? this.review.getExpanded() : null;
    }

    public void setReviewObject(Review r) {
        this.review = new ExpandableField<Review>(r.getId(), r);
    }

    public String getSourceTransfer() {
        return this.sourceTransfer != null ? this.sourceTransfer.getId() : null;
    }

    public void setSourceTransfer(String sourceTransferId) {
        this.sourceTransfer = Charge.setExpandableFieldId(sourceTransferId, this.sourceTransfer);
    }

    public Transfer getSourceTransferObject() {
        return this.sourceTransfer != null ? this.sourceTransfer.getExpanded() : null;
    }

    public void setSourceTransferObject(Transfer c) {
        this.sourceTransfer = new ExpandableField<Transfer>(c.getId(), c);
    }

    public String getTransfer() {
        return this.transfer != null ? this.transfer.getId() : null;
    }

    public void setTransfer(String transferId) {
        this.transfer = Charge.setExpandableFieldId(transferId, this.transfer);
    }

    public Transfer getTransferObject() {
        return this.transfer != null ? this.transfer.getExpanded() : null;
    }

    public void setTransferObject(Transfer c) {
        this.transfer = new ExpandableField<Transfer>(c.getId(), c);
    }

    public Charge capture() throws StripeException {
        return this.capture(null, null);
    }

    public Charge capture(RequestOptions options) throws StripeException {
        return this.capture(null, options);
    }

    public Charge capture(Map<String, Object> params) throws StripeException {
        return this.capture(params, null);
    }

    public Charge capture(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Charge.request(ApiResource.RequestMethod.POST, String.format("%s/capture", Charge.instanceUrl(Charge.class, this.getId())), params, Charge.class, options);
    }

    public static Charge create(Map<String, Object> params) throws StripeException {
        return Charge.create(params, null);
    }

    public static Charge create(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Charge.request(ApiResource.RequestMethod.POST, Charge.classUrl(Charge.class), params, Charge.class, options);
    }

    public static ChargeCollection list(Map<String, Object> params) throws StripeException {
        return Charge.list(params, null);
    }

    public static ChargeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Charge.requestCollection(Charge.classUrl(Charge.class), params, ChargeCollection.class, options);
    }

    public Charge markFraudulent(RequestOptions options) throws StripeException {
        Map<String, Map<String, String>> params = Collections.singletonMap(FRAUD_DETAILS, Collections.singletonMap("user_report", "fraudulent"));
        return this.update(params, options);
    }

    public Charge markSafe(RequestOptions options) throws StripeException {
        Map<String, Map<String, String>> params = Collections.singletonMap(FRAUD_DETAILS, Collections.singletonMap("user_report", "safe"));
        return this.update(params, options);
    }

    @Deprecated
    public Charge refund() throws StripeException {
        return this.refund(null, null);
    }

    @Deprecated
    public Charge refund(RequestOptions options) throws StripeException {
        return this.refund(null, options);
    }

    @Deprecated
    public Charge refund(Map<String, Object> params) throws StripeException {
        return this.refund(params, null);
    }

    @Deprecated
    public Charge refund(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Charge.request(ApiResource.RequestMethod.POST, String.format("%s/refund", Charge.instanceUrl(Charge.class, this.getId())), params, Charge.class, options);
    }

    public static Charge retrieve(String id) throws StripeException {
        return Charge.retrieve(id, null);
    }

    public static Charge retrieve(String id, RequestOptions options) throws StripeException {
        return Charge.retrieve(id, null, options);
    }

    public static Charge retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        return Charge.request(ApiResource.RequestMethod.GET, Charge.instanceUrl(Charge.class, id), params, Charge.class, options);
    }

    public Charge update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Charge update(Map<String, Object> params, RequestOptions options) throws StripeException {
        return Charge.request(ApiResource.RequestMethod.POST, Charge.instanceUrl(Charge.class, this.id), params, Charge.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountRefunded() {
        return this.amountRefunded;
    }

    @Generated
    public AlternateStatementDescriptors getAlternateStatementDescriptors() {
        return this.alternateStatementDescriptors;
    }

    @Generated
    public Boolean getCaptured() {
        return this.captured;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFailureCode() {
        return this.failureCode;
    }

    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Generated
    public FraudDetails getFraudDetails() {
        return this.fraudDetails;
    }

    @Generated
    public Level3 getLevel3() {
        return this.level3;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Outcome getOutcome() {
        return this.outcome;
    }

    @Generated
    public Boolean getPaid() {
        return this.paid;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @Generated
    public Boolean getRefunded() {
        return this.refunded;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public ExternalAccount getSource() {
        return this.source;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Deprecated
    @Generated
    public Card getCard() {
        return this.card;
    }

    @Deprecated
    @Generated
    public Boolean getDisputed() {
        return this.disputed;
    }

    @Deprecated
    @Generated
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountRefunded(Long amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Generated
    public void setAlternateStatementDescriptors(AlternateStatementDescriptors alternateStatementDescriptors) {
        this.alternateStatementDescriptors = alternateStatementDescriptors;
    }

    @Generated
    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    @Generated
    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    @Generated
    public void setFraudDetails(FraudDetails fraudDetails) {
        this.fraudDetails = fraudDetails;
    }

    @Generated
    public void setLevel3(Level3 level3) {
        this.level3 = level3;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    @Generated
    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    @Generated
    public void setReceiptEmail(String receiptEmail) {
        this.receiptEmail = receiptEmail;
    }

    @Generated
    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    @Generated
    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    @Generated
    public void setRefunds(ChargeRefundCollection refunds) {
        this.refunds = refunds;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setSource(ExternalAccount source) {
        this.source = source;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTransferGroup(String transferGroup) {
        this.transferGroup = transferGroup;
    }

    @Generated
    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @Deprecated
    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Deprecated
    @Generated
    public void setDisputed(Boolean disputed) {
        this.disputed = disputed;
    }

    @Deprecated
    @Generated
    public void setStatementDescription(String statementDescription) {
        this.statementDescription = statementDescription;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Charge)) {
            return false;
        }
        Charge other = (Charge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountRefunded = this.getAmountRefunded();
        Long other$amountRefunded = other.getAmountRefunded();
        if (this$amountRefunded == null ? other$amountRefunded != null : !((Object)this$amountRefunded).equals(other$amountRefunded)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$applicationFee = this.getApplicationFee();
        String other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !this$applicationFee.equals(other$applicationFee)) {
            return false;
        }
        AlternateStatementDescriptors this$alternateStatementDescriptors = this.getAlternateStatementDescriptors();
        AlternateStatementDescriptors other$alternateStatementDescriptors = other.getAlternateStatementDescriptors();
        if (this$alternateStatementDescriptors == null ? other$alternateStatementDescriptors != null : !((Object)this$alternateStatementDescriptors).equals(other$alternateStatementDescriptors)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        Boolean this$captured = this.getCaptured();
        Boolean other$captured = other.getCaptured();
        if (this$captured == null ? other$captured != null : !((Object)this$captured).equals(other$captured)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$dispute = this.getDispute();
        String other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) {
            return false;
        }
        String this$failureCode = this.getFailureCode();
        String other$failureCode = other.getFailureCode();
        if (this$failureCode == null ? other$failureCode != null : !this$failureCode.equals(other$failureCode)) {
            return false;
        }
        String this$failureMessage = this.getFailureMessage();
        String other$failureMessage = other.getFailureMessage();
        if (this$failureMessage == null ? other$failureMessage != null : !this$failureMessage.equals(other$failureMessage)) {
            return false;
        }
        FraudDetails this$fraudDetails = this.getFraudDetails();
        FraudDetails other$fraudDetails = other.getFraudDetails();
        if (this$fraudDetails == null ? other$fraudDetails != null : !((Object)this$fraudDetails).equals(other$fraudDetails)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        Level3 this$level3 = this.getLevel3();
        Level3 other$level3 = other.getLevel3();
        if (this$level3 == null ? other$level3 != null : !((Object)this$level3).equals(other$level3)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        Outcome this$outcome = this.getOutcome();
        Outcome other$outcome = other.getOutcome();
        if (this$outcome == null ? other$outcome != null : !((Object)this$outcome).equals(other$outcome)) {
            return false;
        }
        Boolean this$paid = this.getPaid();
        Boolean other$paid = other.getPaid();
        if (this$paid == null ? other$paid != null : !((Object)this$paid).equals(other$paid)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$receiptNumber = this.getReceiptNumber();
        String other$receiptNumber = other.getReceiptNumber();
        if (this$receiptNumber == null ? other$receiptNumber != null : !this$receiptNumber.equals(other$receiptNumber)) {
            return false;
        }
        Boolean this$refunded = this.getRefunded();
        Boolean other$refunded = other.getRefunded();
        if (this$refunded == null ? other$refunded != null : !((Object)this$refunded).equals(other$refunded)) {
            return false;
        }
        ChargeRefundCollection this$refunds = this.getRefunds();
        ChargeRefundCollection other$refunds = other.getRefunds();
        if (this$refunds == null ? other$refunds != null : !((Object)this$refunds).equals(other$refunds)) {
            return false;
        }
        String this$review = this.getReview();
        String other$review = other.getReview();
        if (this$review == null ? other$review != null : !this$review.equals(other$review)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        ExternalAccount this$source = this.getSource();
        ExternalAccount other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        String this$sourceTransfer = this.getSourceTransfer();
        String other$sourceTransfer = other.getSourceTransfer();
        if (this$sourceTransfer == null ? other$sourceTransfer != null : !this$sourceTransfer.equals(other$sourceTransfer)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$transfer = this.getTransfer();
        String other$transfer = other.getTransfer();
        if (this$transfer == null ? other$transfer != null : !this$transfer.equals(other$transfer)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        if (this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup)) {
            return false;
        }
        String this$authorizationCode = this.getAuthorizationCode();
        String other$authorizationCode = other.getAuthorizationCode();
        if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        Boolean this$disputed = this.getDisputed();
        Boolean other$disputed = other.getDisputed();
        if (this$disputed == null ? other$disputed != null : !((Object)this$disputed).equals(other$disputed)) {
            return false;
        }
        String this$statementDescription = this.getStatementDescription();
        String other$statementDescription = other.getStatementDescription();
        return !(this$statementDescription == null ? other$statementDescription != null : !this$statementDescription.equals(other$statementDescription));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Charge;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountRefunded = this.getAmountRefunded();
        result = result * 59 + ($amountRefunded == null ? 43 : ((Object)$amountRefunded).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : $applicationFee.hashCode());
        AlternateStatementDescriptors $alternateStatementDescriptors = this.getAlternateStatementDescriptors();
        result = result * 59 + ($alternateStatementDescriptors == null ? 43 : ((Object)$alternateStatementDescriptors).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        Boolean $captured = this.getCaptured();
        result = result * 59 + ($captured == null ? 43 : ((Object)$captured).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : $dispute.hashCode());
        String $failureCode = this.getFailureCode();
        result = result * 59 + ($failureCode == null ? 43 : $failureCode.hashCode());
        String $failureMessage = this.getFailureMessage();
        result = result * 59 + ($failureMessage == null ? 43 : $failureMessage.hashCode());
        FraudDetails $fraudDetails = this.getFraudDetails();
        result = result * 59 + ($fraudDetails == null ? 43 : ((Object)$fraudDetails).hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        Level3 $level3 = this.getLevel3();
        result = result * 59 + ($level3 == null ? 43 : ((Object)$level3).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        Outcome $outcome = this.getOutcome();
        result = result * 59 + ($outcome == null ? 43 : ((Object)$outcome).hashCode());
        Boolean $paid = this.getPaid();
        result = result * 59 + ($paid == null ? 43 : ((Object)$paid).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $receiptNumber = this.getReceiptNumber();
        result = result * 59 + ($receiptNumber == null ? 43 : $receiptNumber.hashCode());
        Boolean $refunded = this.getRefunded();
        result = result * 59 + ($refunded == null ? 43 : ((Object)$refunded).hashCode());
        ChargeRefundCollection $refunds = this.getRefunds();
        result = result * 59 + ($refunds == null ? 43 : ((Object)$refunds).hashCode());
        String $review = this.getReview();
        result = result * 59 + ($review == null ? 43 : $review.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        ExternalAccount $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        String $sourceTransfer = this.getSourceTransfer();
        result = result * 59 + ($sourceTransfer == null ? 43 : $sourceTransfer.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $transfer = this.getTransfer();
        result = result * 59 + ($transfer == null ? 43 : $transfer.hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        String $authorizationCode = this.getAuthorizationCode();
        result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        Boolean $disputed = this.getDisputed();
        result = result * 59 + ($disputed == null ? 43 : ((Object)$disputed).hashCode());
        String $statementDescription = this.getStatementDescription();
        result = result * 59 + ($statementDescription == null ? 43 : $statementDescription.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Outcome
    extends ApiResource {
        String networkStatus;
        String reason;
        String riskLevel;
        Long riskScore;
        ExpandableField<Rule> rule;
        String sellerMessage;
        String type;

        @Deprecated
        public Rule getRule() {
            return this.rule != null ? this.rule.getExpanded() : null;
        }

        @Deprecated
        public void setRule(Rule rule) {
            this.rule = new ExpandableField<Rule>(rule.getId(), rule);
        }

        public String getRuleId() {
            return this.rule != null ? this.rule.getId() : null;
        }

        public void setRuleId(String ruleId) {
            this.rule = Outcome.setExpandableFieldId(ruleId, this.rule);
        }

        public Rule getRuleObject() {
            return this.rule != null ? this.rule.getExpanded() : null;
        }

        public void setRuleObject(Rule rule) {
            this.rule = new ExpandableField<Rule>(rule.getId(), rule);
        }

        @Generated
        public String getNetworkStatus() {
            return this.networkStatus;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getRiskLevel() {
            return this.riskLevel;
        }

        @Generated
        public Long getRiskScore() {
            return this.riskScore;
        }

        @Generated
        public String getSellerMessage() {
            return this.sellerMessage;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setNetworkStatus(String networkStatus) {
            this.networkStatus = networkStatus;
        }

        @Generated
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Generated
        public void setRiskLevel(String riskLevel) {
            this.riskLevel = riskLevel;
        }

        @Generated
        public void setRiskScore(Long riskScore) {
            this.riskScore = riskScore;
        }

        @Generated
        public void setSellerMessage(String sellerMessage) {
            this.sellerMessage = sellerMessage;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Outcome)) {
                return false;
            }
            Outcome other = (Outcome)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$networkStatus = this.getNetworkStatus();
            String other$networkStatus = other.getNetworkStatus();
            if (this$networkStatus == null ? other$networkStatus != null : !this$networkStatus.equals(other$networkStatus)) {
                return false;
            }
            String this$reason = this.getReason();
            String other$reason = other.getReason();
            if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                return false;
            }
            String this$riskLevel = this.getRiskLevel();
            String other$riskLevel = other.getRiskLevel();
            if (this$riskLevel == null ? other$riskLevel != null : !this$riskLevel.equals(other$riskLevel)) {
                return false;
            }
            Long this$riskScore = this.getRiskScore();
            Long other$riskScore = other.getRiskScore();
            if (this$riskScore == null ? other$riskScore != null : !((Object)this$riskScore).equals(other$riskScore)) {
                return false;
            }
            Rule this$rule = this.getRule();
            Rule other$rule = other.getRule();
            if (this$rule == null ? other$rule != null : !((Object)this$rule).equals(other$rule)) {
                return false;
            }
            String this$sellerMessage = this.getSellerMessage();
            String other$sellerMessage = other.getSellerMessage();
            if (this$sellerMessage == null ? other$sellerMessage != null : !this$sellerMessage.equals(other$sellerMessage)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Outcome;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $networkStatus = this.getNetworkStatus();
            result = result * 59 + ($networkStatus == null ? 43 : $networkStatus.hashCode());
            String $reason = this.getReason();
            result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
            String $riskLevel = this.getRiskLevel();
            result = result * 59 + ($riskLevel == null ? 43 : $riskLevel.hashCode());
            Long $riskScore = this.getRiskScore();
            result = result * 59 + ($riskScore == null ? 43 : ((Object)$riskScore).hashCode());
            Rule $rule = this.getRule();
            result = result * 59 + ($rule == null ? 43 : ((Object)$rule).hashCode());
            String $sellerMessage = this.getSellerMessage();
            result = result * 59 + ($sellerMessage == null ? 43 : $sellerMessage.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Rule
        extends StripeObject
        implements HasId {
            String id;
            String action;
            String predicate;

            @Generated
            public String getAction() {
                return this.action;
            }

            @Generated
            public String getPredicate() {
                return this.predicate;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setAction(String action) {
                this.action = action;
            }

            @Generated
            public void setPredicate(String predicate) {
                this.predicate = predicate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Rule)) {
                    return false;
                }
                Rule other = (Rule)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$action = this.getAction();
                String other$action = other.getAction();
                if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                    return false;
                }
                String this$predicate = this.getPredicate();
                String other$predicate = other.getPredicate();
                return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Rule;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $action = this.getAction();
                result = result * 59 + ($action == null ? 43 : $action.hashCode());
                String $predicate = this.getPredicate();
                result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }
    }

    public static class Level3
    extends StripeObject {
        String customerReference;
        List<LineItem> lineItems;
        String merchantReference;
        String shippingAddressZip;
        String shippingFromZip;
        Long shippingAmount;

        @Generated
        public String getCustomerReference() {
            return this.customerReference;
        }

        @Generated
        public List<LineItem> getLineItems() {
            return this.lineItems;
        }

        @Generated
        public String getMerchantReference() {
            return this.merchantReference;
        }

        @Generated
        public String getShippingAddressZip() {
            return this.shippingAddressZip;
        }

        @Generated
        public String getShippingFromZip() {
            return this.shippingFromZip;
        }

        @Generated
        public Long getShippingAmount() {
            return this.shippingAmount;
        }

        @Generated
        public void setCustomerReference(String customerReference) {
            this.customerReference = customerReference;
        }

        @Generated
        public void setLineItems(List<LineItem> lineItems) {
            this.lineItems = lineItems;
        }

        @Generated
        public void setMerchantReference(String merchantReference) {
            this.merchantReference = merchantReference;
        }

        @Generated
        public void setShippingAddressZip(String shippingAddressZip) {
            this.shippingAddressZip = shippingAddressZip;
        }

        @Generated
        public void setShippingFromZip(String shippingFromZip) {
            this.shippingFromZip = shippingFromZip;
        }

        @Generated
        public void setShippingAmount(Long shippingAmount) {
            this.shippingAmount = shippingAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Level3)) {
                return false;
            }
            Level3 other = (Level3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customerReference = this.getCustomerReference();
            String other$customerReference = other.getCustomerReference();
            if (this$customerReference == null ? other$customerReference != null : !this$customerReference.equals(other$customerReference)) {
                return false;
            }
            List<LineItem> this$lineItems = this.getLineItems();
            List<LineItem> other$lineItems = other.getLineItems();
            if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
                return false;
            }
            String this$merchantReference = this.getMerchantReference();
            String other$merchantReference = other.getMerchantReference();
            if (this$merchantReference == null ? other$merchantReference != null : !this$merchantReference.equals(other$merchantReference)) {
                return false;
            }
            String this$shippingAddressZip = this.getShippingAddressZip();
            String other$shippingAddressZip = other.getShippingAddressZip();
            if (this$shippingAddressZip == null ? other$shippingAddressZip != null : !this$shippingAddressZip.equals(other$shippingAddressZip)) {
                return false;
            }
            String this$shippingFromZip = this.getShippingFromZip();
            String other$shippingFromZip = other.getShippingFromZip();
            if (this$shippingFromZip == null ? other$shippingFromZip != null : !this$shippingFromZip.equals(other$shippingFromZip)) {
                return false;
            }
            Long this$shippingAmount = this.getShippingAmount();
            Long other$shippingAmount = other.getShippingAmount();
            return !(this$shippingAmount == null ? other$shippingAmount != null : !((Object)this$shippingAmount).equals(other$shippingAmount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Level3;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customerReference = this.getCustomerReference();
            result = result * 59 + ($customerReference == null ? 43 : $customerReference.hashCode());
            List<LineItem> $lineItems = this.getLineItems();
            result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
            String $merchantReference = this.getMerchantReference();
            result = result * 59 + ($merchantReference == null ? 43 : $merchantReference.hashCode());
            String $shippingAddressZip = this.getShippingAddressZip();
            result = result * 59 + ($shippingAddressZip == null ? 43 : $shippingAddressZip.hashCode());
            String $shippingFromZip = this.getShippingFromZip();
            result = result * 59 + ($shippingFromZip == null ? 43 : $shippingFromZip.hashCode());
            Long $shippingAmount = this.getShippingAmount();
            result = result * 59 + ($shippingAmount == null ? 43 : ((Object)$shippingAmount).hashCode());
            return result;
        }

        public static class LineItem
        extends StripeObject {
            Long discountAmount;
            String productCode;
            String productDescription;
            Long quantity;
            Long taxAmount;
            Long unitCost;

            @Generated
            public Long getDiscountAmount() {
                return this.discountAmount;
            }

            @Generated
            public String getProductCode() {
                return this.productCode;
            }

            @Generated
            public String getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public Long getTaxAmount() {
                return this.taxAmount;
            }

            @Generated
            public Long getUnitCost() {
                return this.unitCost;
            }

            @Generated
            public void setDiscountAmount(Long discountAmount) {
                this.discountAmount = discountAmount;
            }

            @Generated
            public void setProductCode(String productCode) {
                this.productCode = productCode;
            }

            @Generated
            public void setProductDescription(String productDescription) {
                this.productDescription = productDescription;
            }

            @Generated
            public void setQuantity(Long quantity) {
                this.quantity = quantity;
            }

            @Generated
            public void setTaxAmount(Long taxAmount) {
                this.taxAmount = taxAmount;
            }

            @Generated
            public void setUnitCost(Long unitCost) {
                this.unitCost = unitCost;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LineItem)) {
                    return false;
                }
                LineItem other = (LineItem)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$discountAmount = this.getDiscountAmount();
                Long other$discountAmount = other.getDiscountAmount();
                if (this$discountAmount == null ? other$discountAmount != null : !((Object)this$discountAmount).equals(other$discountAmount)) {
                    return false;
                }
                String this$productCode = this.getProductCode();
                String other$productCode = other.getProductCode();
                if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
                    return false;
                }
                String this$productDescription = this.getProductDescription();
                String other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                Long this$quantity = this.getQuantity();
                Long other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                    return false;
                }
                Long this$taxAmount = this.getTaxAmount();
                Long other$taxAmount = other.getTaxAmount();
                if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
                    return false;
                }
                Long this$unitCost = this.getUnitCost();
                Long other$unitCost = other.getUnitCost();
                return !(this$unitCost == null ? other$unitCost != null : !((Object)this$unitCost).equals(other$unitCost));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LineItem;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $discountAmount = this.getDiscountAmount();
                result = result * 59 + ($discountAmount == null ? 43 : ((Object)$discountAmount).hashCode());
                String $productCode = this.getProductCode();
                result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
                String $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                Long $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                Long $taxAmount = this.getTaxAmount();
                result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
                Long $unitCost = this.getUnitCost();
                result = result * 59 + ($unitCost == null ? 43 : ((Object)$unitCost).hashCode());
                return result;
            }
        }
    }

    public static class FraudDetails
    extends StripeObject {
        public static final String USER_REPORT = "user_report";
        String userReport;
        String stripeReport;

        @Generated
        public String getUserReport() {
            return this.userReport;
        }

        @Generated
        public String getStripeReport() {
            return this.stripeReport;
        }

        @Generated
        public void setUserReport(String userReport) {
            this.userReport = userReport;
        }

        @Generated
        public void setStripeReport(String stripeReport) {
            this.stripeReport = stripeReport;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FraudDetails)) {
                return false;
            }
            FraudDetails other = (FraudDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userReport = this.getUserReport();
            String other$userReport = other.getUserReport();
            if (this$userReport == null ? other$userReport != null : !this$userReport.equals(other$userReport)) {
                return false;
            }
            String this$stripeReport = this.getStripeReport();
            String other$stripeReport = other.getStripeReport();
            return !(this$stripeReport == null ? other$stripeReport != null : !this$stripeReport.equals(other$stripeReport));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FraudDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userReport = this.getUserReport();
            result = result * 59 + ($userReport == null ? 43 : $userReport.hashCode());
            String $stripeReport = this.getStripeReport();
            result = result * 59 + ($stripeReport == null ? 43 : $stripeReport.hashCode());
            return result;
        }
    }

    public static class AlternateStatementDescriptors
    extends StripeObject {
        String kana;
        String kanji;

        @Generated
        public String getKana() {
            return this.kana;
        }

        @Generated
        public String getKanji() {
            return this.kanji;
        }

        @Generated
        public void setKana(String kana) {
            this.kana = kana;
        }

        @Generated
        public void setKanji(String kanji) {
            this.kanji = kanji;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlternateStatementDescriptors)) {
                return false;
            }
            AlternateStatementDescriptors other = (AlternateStatementDescriptors)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$kana = this.getKana();
            String other$kana = other.getKana();
            if (this$kana == null ? other$kana != null : !this$kana.equals(other$kana)) {
                return false;
            }
            String this$kanji = this.getKanji();
            String other$kanji = other.getKanji();
            return !(this$kanji == null ? other$kanji != null : !this$kanji.equals(other$kanji));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AlternateStatementDescriptors;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $kana = this.getKana();
            result = result * 59 + ($kana == null ? 43 : $kana.hashCode());
            String $kanji = this.getKanji();
            result = result * 59 + ($kanji == null ? 43 : $kanji.hashCode());
            return result;
        }
    }
}

