<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    ObjectTransaction   objTran     =   process.getTransaction ();
    String              nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICANTS);
    String              homePage    =   WebUtils.getSamePageInRenderMode(request, "Page");
    JobStatus           jobStatus   =   (JobStatus) process.getAttribute("JobStatus"); 

    if(jobStatus == null && request.getParameter("JobStatus") != null)
    {
        jobStatus   =   JobStatus.forName((String) request.getParameter("JobStatus"));
    }

    Job[]               jobs        =   Job.SearchByAll().andJobStatus(new EqualsFilter<>(jobStatus))
                                                        .andSecUser(new EqualsFilter(SecUser.getTXUser(transaction)))
                                                        .search(transaction);

    process.setAttribute("JobStatus", jobStatus);
%>

    
    <oneit:form name="editJob" method="post"    enctype="multipart/form-data">

        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="dashboard-content-area second-part">
            <div class="jobs-list-shorting">
                <div class="d-job-title all-jobs-title">All Jobs</div>
                <div class="job-filter">
                    <ul class="">
                        <li class="lable-job-shorting">showing</li>
                        <li class="<%= (jobStatus == null ? "active" : "" )%>">
                            <oneit:button   value="All Jobs"   name="gotoPage" skin="link"
                                            requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage)
                                                                            .mapEntry("procParams", CollectionUtils.mapEntry("JobStatus", null).toMap())
                                                                            .toMap() %>"/>
                        </li>
                        <%
                            for (JobStatus status : JobStatus.getJobStatusArray())
                            {
                        %>
                                <li class="<%= (jobStatus != null && jobStatus == status ? "active" : "" )%>">
                                    <oneit:button   value="<%= status.getName() %>"   name="gotoPage" skin="link"
                                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", homePage )
                                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobStatus", status).toMap())
                                                                                    .toMap() %>"/>
                                </li>
                        <%
                            }
                        %>
                    </ul>
                </div>
                <div class="shorting-dropdown">
                    <span class="order-label">order by</span>
                    <select class="form-control">
                        <option>Alphabetical (A-Z)</option>
                        <option>Alphabetical (Z-A)</option>
                    </select>
                </div>
            </div>
                    
            <oneit:dynInclude   page="/extensions/adminportal/inc/job_list.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"
                                NextPage="<%= nextPage%>"    HomePage="<%= homePage%>"    Jobs="<%= jobs %>"    JobStatus="<%= jobStatus %>"   />
            
        </div>
    </oneit:form>
</oneit:dynIncluded>
