/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.logging.LoggingArea;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.security.SecUser;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessFormProcessor;
import oneit.servlets.process.ORMProcessState;
import oneit.utils.BusinessException;
import performa.orm.AssessmentCriteria;
import performa.orm.AssessmentCriteriaTemplate;
import performa.orm.Job;

/**
 *
 * @author nilu
 */
public class SaveRequirementsTemplateFP extends ORMProcessFormProcessor
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        final   HttpServletRequest  request     =   submission.getRequest();
        ObjectTransaction           objTran     =   process.getTransaction();
        Job                         job         =   (Job) request.getAttribute("Job");
        
        LogMgr.log(LoggingArea.ALL, LogLevel.PROCESSING1, "Inside SaveRequirementsTemplateFP for create new template.");
            
        BusinessObjectParser.assertFieldCondition(job.getAssessmentTemplateName()!= null, job , Job.FIELD_AssessmentTemplateName, "mandatory");

        objTran.runInNewTX((ObjectTransaction newObjTran) -> {
            
            AssessmentCriteriaTemplate newTemplate  = AssessmentCriteriaTemplate.createAssessmentCriteriaTemplate(newObjTran);
            
            newTemplate.setUser(SecUser.getTXUser(newObjTran));
            newTemplate.setTemplateName(job.getAssessmentTemplateName());
            
            for (AssessmentCriteria criteria : job.getAssessmentCriteriasSet())
            {
                AssessmentCriteria criteriaCopy = AssessmentCriteria.createAssessmentCriteria(newObjTran);
            
                criteriaCopy.copyAttributesFrom(criteria);

                newTemplate.addToAssessmentCriterias(criteriaCopy);
            }
            
        });
        
        return RedisplayResult.getInstance();
    }
}