<%@ page extends="oneit.servlets.process.AJAXProcessJSP" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils" %>

<%! protected String getName (ServletConfig config) { return "job_match_questions_jsp"; } %>

<%
    ORMProcessState     process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
    Long                jobAppId        =   (Long) process.getAttribute("JobApplicationID");
    JobApplication      jobApplication  =   JobApplication.getJobApplicationByID(objTran, jobAppId);
    Job                 job             =   jobApplication.getJob();
    List<Question>      totalQuestions  =   (List<Question>) process.getAttribute("TotalQuestions");
    List<Question>      allQuestions    =   (List<Question>) process.getAttribute("AllQuestions");
    int                 actualNumber    =   request.getParameter ("actualNumber") != null ? Integer.valueOf(request.getParameter ("actualNumber")) : (int) getData(request, "actualNumber")  ;
    int                 questionNumber  =   request.getParameter ("questionNumber") != null ? Integer.valueOf(request.getParameter ("questionNumber")) : (int) getData(request, "questionNumber")  ;
    Question            question        =   allQuestions.get(questionNumber);

    question    =   (Question)question.getInTransaction (objTran);

    QuestionType        questionType    =   question.getQuestionType();
    String              exitPage        =   WebUtils.getArticleLink(request, objTran, WebUtils.APPLY_JOB, "Page") + "&id=" + job.getID() + "&key=" + job.getRandomKey();
    String              currentPage     =   WebUtils.getArticleLink(request, objTran, WebUtils.JOB_APPLICATION, "JobMatchAssessment");
    String              nextPage        =   WebUtils.getArticleLink(request, objTran, WebUtils.JOB_APPLICATION, "SubmitApplication");
    String              culturePage     =   WebUtils.getArticleLink(request, objTran, WebUtils.JOB_APPLICATION, "WorkplaceCulture");
%>

<oneit:form name="editApplication"   method="POST">
    
    <oneit:evalBody buffer="<%= getBuffer(request) %>">
        <%
            if(actualNumber == 1 )
            {
                int     maxRating   =   7;
                int     midRating   =   4;
                String  otherRating =   "2, 3, 5, 6";
        %>
                <div class="main-sc-section sj-1">
                    <p>Using the scale given, indicate how important to you are the following aspects in your work life. Use the following system:</p>
                    <ul class="security-level">
                        <li><span>1</span> means of very little importance to you</li>
                        <li><oneit:toString value="<%= midRating %>"  mode="EscapeHTML"/> means about average in importance to you</li>
                        <li><oneit:toString value="<%= maxRating %>"  mode="EscapeHTML"/> means of high importance to you</li>
                    </ul>
                    <p>Use the other numbers (<oneit:toString value="<%= otherRating %>"    mode="EscapeHTML"/>) to indicate in-between levels of importance to you.</p>            
                </div>
                <div class="selection-br-line"></div>
        <%
            }
            else if(questionType == QuestionType.IPSATIVE && actualNumber == 31)
            {
        %>
                <div class="main-sc-section sj-1">
                    <p>
                        For questions like these, indicate your preference by selecting the number closest to the term or idea that's most like you. We know that it can be challenging to make a choice sometimes, but try to avoid selecting the middle value.
                    </p>
                </div>
                <div class="selection-br-line"></div>
        <%
            }
        %>
        <div class="main-sc-section main-rate-section">
                        
        <%
            int totNoOfQuestions    =   totalQuestions.size();

            if(actualNumber <= totNoOfQuestions)
            {
                String      numberText          =   actualNumber + "/" + totNoOfQuestions;
                boolean     completeApplication =   questionNumber + 1 >= allQuestions.size();

                if(questionType == QuestionType.SCALAR)
                {
        %>    
                    <div class="rateing-title">
                        Rate the importance of each item below
                        <span><oneit:toString value="<%= numberText %>"   mode="EscapeHTML"/></span>
                    </div>

                    <div class="rating-box-title">
                        <oneit:toString value="<%= question.getDescription() %>"    mode="EscapeHTML"/>
                    </div>
            <%
                }
                else
                {
            %>    
                    <div class="rateing-title">
                        Select your preference on the scale below 
                        <span><oneit:toString value="<%= numberText %>"   mode="EscapeHTML"/></span>
                    </div>
            <%
                }
            %>
                <div class="ratting-box">
                <%
                    if(questionType == QuestionType.SCALAR)
                    {
                %>
                        <span>Very little importance</span>
                <%
                    }
                    else
                    {
                %>
                        <span class="left-s-label"><div><%= FormatUtils.stringify(question.getDescription(), "EscapeHTML") %></div></span> <!-- toString tag not used due to styling issue with additional span tag -->
                <%
                    }
                %>
                    <ul class="pagination ratting-number">
                    <%
                        for(int index=1; index <= (questionType == QuestionType.SCALAR ? 7 : 5); index++)
                        {
                            int         actNumber   =   questionType == QuestionType.SCALAR ?  actualNumber + 1 : actualNumber + 2;
                    %>
                            <li class="<%=((questionType == QuestionType.SCALAR) ?  "scaler" : "ipsative")%>">
                                <a href="javascript:void(0);">
                                    <input  type="radio"    name="answer"   id="<%= index %>"   onchange="gotoNextQuestion(<%= questionNumber + 1 %> , <%= actNumber %>, <%= completeApplication %>, <%= index %>);"   class="answer_radio">
                                    <label  for="<%= index %>"><%= index %></label>
                                </a>
                            </li>
                    <%
                        }
                    %>
                    </ul>
                <%
                    if(questionType == QuestionType.SCALAR)
                    {
                %>
                        <span>High importance</span>
                <%
                    }
                    else if(question.getRightQuestion() != null)
                    {
                %>
                        <span class="right-s-label"><div><%= FormatUtils.stringify(question.getRightQuestion().getDescription(), "EscapeHTML") %></div></span>
                <%
                    }
                %>
                </div>
        <%
            }
        %>
        </div>
        <%
            if(!jobApplication.cultureCompleted())
            {
        %>
                <oneit:button   value=" "    name="gotoPage"    id="gotoPageNext" cssClass="box-btn"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", culturePage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                    .toMap() %>"/>
        <%
            }
            else
            {
        %>
                <oneit:button   value=" "    name="completeApplication"  id="gotoPageNext" cssClass="box-btn hide"
                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                    .mapEntry ("restartProcess", Boolean.TRUE)
                                                                    .mapEntry("attribNamesToRestore", Collections.singleton("JobApplication"))
                                                                    .toMap() %>"/>
        <%
            }
        %>
    </oneit:evalBody>
       
</oneit:form>