import { Component } from '@angular/core';
import { takeUntil } from 'rxjs/operators';
import { AuthService } from '../../services/auth.service';
import { Router } from '@angular/router';
import { BaseComponent } from '../../base/base.component';
import { EXTERNAL_LINKS } from '../../config/constants';

@Component({
    selector: 'app-left-sidebar',
    templateUrl: './left-sidebar.component.html',
    styleUrls: ['./left-sidebar.component.scss']
})
export class LeftSidebarComponent extends BaseComponent {

    year = new Date().getFullYear();

    constructor(
        private as: AuthService,
        private r: Router
    ) {
        super();
    }

    logout(): void {
        this.isLoading = true;
        this.as.logout()
            .pipe(takeUntil(this.componentInView))
            .subscribe(() => {
                this.r.navigate(['/my-career-web/auth/login']);
                this.isLoading = false;
            });
    }

    openPrivacyPolicy(): void {
        window.location.href = EXTERNAL_LINKS.PRIVACY_POLICY;
    }

}
