import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';

import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class ListWorkFlowsService {

  constructor(
    private searchService: SearchService,
    private utilsService: UtilsService
  ) {
  }

  getWorkFlows(queryParams, assocs): Observable<any> {
    return this.searchService.searchAndSaveSearchRequest('WorkFlowTemplates', 'All', queryParams,
      assocs, null, null, null, null, 'ListWorkFlow', false)
      .map(
        data =>
          this.utilsService.convertResponseToObjects(data, assocs)
      );
  }

}
