import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';

import { SearchService } from '../../oneit/services/search.service';
import { UtilsService } from '../../oneit/services/utils.service';

@Injectable()
export class ListMessageTemplateService {

  constructor(
    private searchService: SearchService,
    private utilsService: UtilsService
  ) {
  }

  getMessageTemplates(queryParams, assocs): Observable<any> {
    return this.searchService.searchAndSaveSearchRequest('MessageTemplates', 'All',
      queryParams, assocs, null, null, null, null, 'ListMessageTemplate', false)
      .map(
        data =>
          this.utilsService.convertResponseToObjects(data, assocs)
      );
  }

}
