import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { PlaceholderOptionsModel } from './models/placeholderOptions.model';
import { TemplateTypeModel } from './models/templateTypeModel';
import { EnumService } from './oneit/services/enum.service';

@Injectable()

export class AppService {

  HiringTeam = 'ID:37952977';

  constructor(
    private enumService: EnumService
  ) {

  }

  getMessageTemplateTypeEnum(): Observable<Array<TemplateTypeModel>> {
    return this.enumService.getEnums('TemplateTypes', true);
  }

  getPlaceholderOptionsEnum(): Observable<Array<PlaceholderOptionsModel>> {
    return this.enumService.getEnums('PlaceholderOptions', true);
  }

  // Helper functions

  moveCreatedToUpdated(data, createdObjs, updatedObjs, deletedObjs = null): void {
    Object.keys(createdObjs)
      .forEach(nData => {
        if (data.created[nData]) {
          updatedObjs[data.created[nData]] = createdObjs[nData];
          updatedObjs[data.created[nData]].ObjectID = data.created[nData];
          // tslint:disable-next-line:no-dynamic-delete
          delete createdObjs[nData];
        }
      });
    if (deletedObjs) {
      Object.keys(deletedObjs)
        .forEach(nData => {
          if (data.deleted.indexOf(nData) > -1) {
            // tslint:disable-next-line:no-dynamic-delete
            delete deletedObjs[nData];
          }
        });
    }
  }
}
