import { NgModule } from '@angular/core';
import { FormBuilder } from '@angular/forms';

import { ConfirmationService, EditorModule, OverlayPanelModule } from 'primeng/primeng';

import { AppComponent } from './app.component';
import { AppRoutingModule } from './app.routing';
import { AppService } from './app.service';
import { EditMessageTemplateComponent } from './components/edit-message-template/edit-message-template.component';
import { EditMessageTemplateService } from './components/edit-message-template/edit-message-template.service';
import { ListMessageTemplateComponent } from './components/list-message-template/list-message-template.component';
import { ListMessageTemplateService } from './components/list-message-template/list-message-template.service';
import { ListWorkFlowsComponent } from './components/list-work-flows/list-work-flows.component';
import { ListWorkFlowsService } from './components/list-work-flows/list-work-flows.service';

import { FullLayoutComponent } from './oneit/components/full-layout/full-layout.component';
import { OneITModule } from './oneit/oneit.module';

@NgModule({
  imports: [
    AppRoutingModule,
    OneITModule,
    EditorModule,
    OverlayPanelModule
  ],
  declarations: [
    AppComponent,
    FullLayoutComponent,
    EditMessageTemplateComponent,
    ListMessageTemplateComponent,
    ListWorkFlowsComponent
  ],
  providers: [
    FormBuilder,
    ConfirmationService,
    AppService,
    EditMessageTemplateService,
    ListMessageTemplateService,
    ListWorkFlowsService
  ],
  bootstrap: [AppComponent]
})

export class AppModule {
  constructor() {
  }
}
