package performa.utils;

import oneit.business.content.Article;
import oneit.business.content.jsp.ContentDF;
import oneit.servlets.jsp.BaseJSP;
import oneit.utils.CollectionUtils;
import javax.servlet.http.*;
import oneit.business.content.jsp.ShortcutFilter;
import oneit.objstore.BaseBusinessClass;
import oneit.objstore.ObjectTransaction;
import oneit.servlets.jsp.ORMSimpleAssocTag;
import oneit.servlets.orm.DataMap;


public class WebUtils 
{
    public static String getSamePageInRenderMode (HttpServletRequest request, String renderMode)
    {
        BaseJSP theJSP = (BaseJSP) request.getAttribute(BaseJSP.JSP_SERVLET);
        Article article = (Article)theJSP.getData(request, ContentDF.ARTICLE);
        String  newURI = article.getLink(request, CollectionUtils.mapEntry("cms.rm", renderMode).toMap());

        return newURI;
    }
    
    
    public static String getRadioSingleAssocKey(HttpServletRequest request, BaseBusinessClass bbc, String singleAssocName)
    {
        DataMap             dataMap = DataMap.getDataMap (request, true);
        ORMSimpleAssocTag.SimpleAssocHandler  dih     = new ORMSimpleAssocTag.SimpleAssocHandler (bbc, singleAssocName);
        return dataMap.storeORMHandler (dih, bbc, singleAssocName);
    }
    
    
    public static Article getArticleByShortCut(ObjectTransaction objTran, String shortCut)
    {
        return ShortcutFilter.doShortcutSearch(objTran, shortCut);
    }
}