package performa.orm;

import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.BusinessException;
import performa.orm.types.AssessmentType;


public class Job extends BaseJob
{
    private static final long serialVersionUID = 0L;
    
    // This constructor should not be called
    public Job ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }

    
    @Override
    protected void postInitNewObj() throws BusinessException 
    {
        super.postInitNewObj();
        
        setLevel(Level.createLevel(getTransaction()));
    }
    
    
    public Boolean jobDetailsCompleted()
    {
        return getJobTitle() != null && getJobDescription() != null;
    }
    
    
    public Boolean assessmentCompleted()
    {
        return Boolean.TRUE;
    }
    
    
    public Boolean cultureCompleted()
    {
        return Boolean.FALSE;
    }
    
    
    public Boolean jobMatchCompleted()
    {
        return Boolean.TRUE;
    }
    
    
    public void getSkillsSet()
    {
        AssessmentCriteria.SearchByAll().andAssessmentType(new EqualsFilter<>(AssessmentType.SKILL));
    }
}