package performa.form;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.components.ParticipantInitialisationContext;
import oneit.email.ConfigurableArticleTemplateEmailer;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import oneit.utils.InitialisationException;
import performa.orm.CompanyUser;
import performa.utils.Utils;


public class ResendVerificationFP extends SaveFP
{
    protected ConfigurableArticleTemplateEmailer  emailer;

    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        String              nextPage    =   (String) request.getAttribute("nextPage");
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        
        LogMgr.log(CompanyUser.LOG, LogLevel.PROCESSING1, "Inside ResendVerificationFP resending verification email to company user : ", companyUser);
        
        if(companyUser != null)
        {
            Utils.sendVerificationMail(companyUser, request, emailer, ResendVerificationFP.class.getName());
        }
        
        process.completeAndRestart();
        
        return super.processForm(process, submission, params);
    }
    
    @Override
    public void init(ParticipantInitialisationContext context) throws InitialisationException
    {
        super.init(context);
        
        emailer = (ConfigurableArticleTemplateEmailer) (context.getSingleChild("AccountVerificationEmailer"));
    }
}