import { Component, OnInit } from '@angular/core';
import { BaseComponent } from '../../base/base.component';
import { JobService } from '../../services/job.service';
import { takeUntil } from 'rxjs/operators';
import { UtilsService } from '../../../oneit/services/utils.service';
import { ApplicantJobModel } from '../../models/applicant-job.model';

@Component({
    selector: 'app-jobs',
    templateUrl: './jobs.component.html',
    styleUrls: ['./jobs.component.scss']
})

export class JobsComponent extends BaseComponent implements OnInit {

    assocs = [];
    includeCompleted = false;
    applicantJobs: ApplicantJobModel[] = [];

    constructor(
        private utilsService: UtilsService,
        private jobsService: JobService
    ) {
        super();
    }

    ngOnInit(): void {
        this.getJobApplicants();
    }

    getJobApplicants(): void {
        this.isLoading = true;
        this.jobsService.getApplicantTalentJobs({IncludeCompleted: this.includeCompleted}, this.assocs)
            .pipe(takeUntil(this.componentInView))
            .subscribe(response => {
                this.isLoading = false;
                this.applicantJobs = response;
            }, err => {
                this.isLoading = false;
                this.utilsService.handleError(err);
            })
    }

}
