<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState 	process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction 	objTran         =   process.getTransaction();
    Job                 job             =   (Job) process.getAttribute("Job");
    JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    Candidate           candidate       =   jobApplication.getCandidate();
    boolean             detailed        =   (boolean) getData(request, "Detailed");
    boolean             missingReq      =   jobApplication.hasFailedEssentialRequirements();
%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                        &nbsp;(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)
                <%
                    }
                %>
            </div>
            <div class="by-name">
                <span>
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                <oneit:toString value="<%= job.getLevel() %>"   mode="EscapeHTML" />
            </div>
        </div>
        <div class="white-header">
              <div style="clear:both"></div>
            <div class="applicant-details">
                 <div class="main-appli-name">
                    <div class="appli-name"><oneit:toString value="<%= candidate.getToString() %>"  mode="EscapeHTML"/></div>
                    <div class="appli-applied">
                        Applied <oneit:toString  value="<%= jobApplication.getSubmittedDate() %>"   mode="MidDate"/>
                    </div>
                </div>
                <div class="rank-info">
                    <div class="overall-suit">
                        <span>OVERALL RANK</span>
                        <oneit:toString value="<%= jobApplication.getOverallRank() %>"   mode="Integer" />
                    </div>
                    <div class="shortlised" style="background-image: url('file:///<%= PDFUtils.FILE_BASE_PATH %>/images/shortlist.png')">
                        Shortlisted
                    </div>
                </div>    
            </div>
             <div class="contact-row">
                <span class="contact-label">E</span>
                 <a href="<%= "mailto:" + candidate.getUser().getUserName() %>">
                    <oneit:toString value="<%= candidate.getUser().getUserName() %>" mode="EscapeHTML" />
                </a>
                <span class="contact-label">P </span>
                <oneit:toString value="<%= candidate.getPhone() %>" mode="EscapeHTML" />
                <span class="contact-label"><img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/icon-location.png" /></span>
                <span>Melbourne,Victoria Austrilia 3000 <div class="orange-text">Does not want to relocate</div></span>
                <span class="contact-label"><img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/icon-remote.png" /></span>
                <span class="green-text">Prefers to work remote</span>
            </div>
        </div>
                
        <div class="">
            <!--Requirements-->   
            <%
                if(job.getIncludeAssessmentCriteria() == Boolean.TRUE)
                {
            %>   
                    <table width="100%" cellspacing="0" cellpadding="0" class="charts-table">
                        <tr>
                            <td class="chart-cell">
                                <div class="cell-title">Requirements</div>
                                <div>
                                    <img src="file:///<%= jobApplication.getRequirementRingChart() %>" alt="Ring Chart"/>
                                </div>
                                <div class="row four-label">
                                <%
                                    if(detailed)
                                    {
                                        for(CriteriaType ct: CriteriaType.getCriteriaTypeArray())
                                        {
                                            MultiHashtable<Importance, AssessmentCriteriaAnswer> negativeAnswers    =   jobApplication.getNegativeACByImportance(ct);
                                            
                                            int essentialNo     =   negativeAnswers.getValuesForKeyNN(Importance.ESSENTIAL).size();
                                            int hDesirableNo    =   negativeAnswers.getValuesForKeyNN(Importance.HIGHLY_DESIRABLE).size();

                                            if(essentialNo == 0 && hDesirableNo == 0)
                                            {
                                                continue;
                                            }
                                %>
                                            <div class="col-md-6 col-sm-6 col-xs-6 text-left">
                                                <div class="a-label-row">
                                                    <span class="r-y-label pre-dot"><%= ct.getDescription() %></span>
                                                    <%
                                                        if(hDesirableNo > 0)
                                                        {
                                                    %>
                                                            <span class="common-dot yellow-dot"></span>
                                                            <span class="r-y-label pre-dot" onclick="focusReqDiv('.<%= Importance.HIGHLY_DESIRABLE %>')">(<%=hDesirableNo%>)</span>
                                                    <%
                                                        }
                                                            
                                                        if(essentialNo > 0)
                                                        {
                                                    %>
                                                            <span class="common-dot red-dot"></span>
                                                            <span class="r-y-label pre-dot" onclick="focusReqDiv('.<%= Importance.ESSENTIAL %>')">(<%=essentialNo%>)</span>
                                                    <%
                                                        }
                                                    %>
                                                </div> 
                                            </div>
                                <%
                                        }
                                    }
                                %>
                                </div>
                            </td>
                            <td class="chart-info-cell">
                            <%
                                MultiHashtable<Importance, AssessmentCriteriaAnswer>    reqAnswersByImportance  =   jobApplication.getRequirementAnswersByImportance();
                                Map<Importance, Long>                                   requirementFitData      =   (Map<Importance, Long>)jobApplication.getRequirementFit();

                                for(Importance importance: Utils.getImportancesForAssessment())
                                {
                                    Long    rating  =   requirementFitData.get(importance);            
                            %>
                                    <div class="appli-row">
                                        <span class="appli-label"><oneit:toString   value="<%= importance %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar"  style="width:<%= rating %>%;" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                        </span>
                                    </div>
                            <%
                                    if(detailed && reqAnswersByImportance.getValuesForKey(importance)!=null)
                                    {
                                        for(AssessmentCriteriaAnswer answer: reqAnswersByImportance.getValuesForKey(importance))
                                        {
                                            String  dotClass    =   answer.getAnswer() ? "" : (importance == Importance.ESSENTIAL ? "red-dot" : (importance == Importance.HIGHLY_DESIRABLE ? "yellow-dot" : ""));
                            %>
                                            <div class="tab-row fixed-height">
                                                <div class="detail-tab-row-title <%= (importance == Importance.ESSENTIAL ? (!missingReq ? "red-requirements" : "green-requirements") : "") %>">
                                                    <span class="dot-icon"></span>
                                                    <oneit:toString value="<%= answer.getAssessmentCriteria().getCriteriaType() %>" mode="EscapeHTML"/>
                                                </div>
                                                <div class="detail-tab-row-text" >
                                                    <oneit:toString value="<%= answer.getAssessmentCriteria() %>" mode="EscapeHTML"/> - 
                                                    <oneit:toString value="<%= answer.getAnswer() ? "Yes" : "No" %>" mode="EscapeHTML"/>
                                                </div>
                                            </div>
                            <%
                                            
                                        }
                                    }
                                }
                            %>
                              
                            </td>
                        </tr>
                    </table>
            <%
                }
            %>   
            
            <!--Role Fit-->   
            <table width="100%" cellspacing="0" cellpadding="0" class="charts-table">
                <tr>
                    <td class="chart-cell">
                        <div class="cell-title">Role Fit</div>
                        <div>
                            <img src="file:///<%= jobApplication.getRoleFitChart() %>" alt="Ring Chart"/>
                        </div>
                        <div class="row four-label">
                        <%
                            List<FactorScore>   factorScores    =   jobApplication.getRoleAreaOfConcerns();

                            if(detailed && !factorScores.isEmpty())
                            {
                                int rowCount    =   (factorScores.size() % 2 == 0) ? (factorScores.size() / 2) : ((factorScores.size() + 1) / 2);
                                
                                for(int i = 0; i < rowCount; i++)
                                {
                                    FactorScore firstScore  =   factorScores.get(i*2);
                                    FactorScore secondScore =   (factorScores.size() > ((i*2) + 1)) ? factorScores.get((i*2) + 1) : null;
                                    
                                    String      dotClass    =   firstScore.getColorCode() != null ? firstScore.getColorCode().getDotCSSClass() : "";
                        %>
                                    <div class="a-label-row">
                                        <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + firstScore.getObjectID() %>')">
                                            <span class="common-dot <%= dotClass %>"></span>
                                            <span class="r-y-label text-dot-dot">
                                                <oneit:toString value="<%= firstScore.getFactor() %>"   mode="EscapeHTML"/>
                                            </span>
                                        </div>
                                    <%
                                        if(secondScore != null)
                                        {
                                            dotClass    =   secondScore.getColorCode() != null ? secondScore.getColorCode().getDotCSSClass() : "";
                                    %>
                                            <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + secondScore.getObjectID() %>')">
                                                <span class="common-dot <%= dotClass %>"></span>
                                                <span class="r-y-label text-dot-dot">
                                                    <oneit:toString value="<%= secondScore.getFactor() %>"  mode="EscapeHTML"/>
                                                </span>
                                            </div>
                                    <%
                                        }
                                    %>
                                    </div>
                        <%
                                }
                            }
                        %>
                        </div>
                    </td>
                    <td class="chart-info-cell">
                        <%
                            Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>   roleScoreMap    =   (Map<FactorClass, Tuple.T3<Double, ColorCode, Double>>)jobApplication.getRoleFit();
                            Map<FactorClass, Map<FactorLevelLink, Map>>             factorClassDtls =   (Map<FactorClass, Map<FactorLevelLink, Map>>) jobApplication.getFactorScoreDetails();

                            for(FactorClass factorClass : factorClassDtls.keySet())
                            {
                                Map<FactorLevelLink, Map>   factorDetails   =   factorClassDtls.get(factorClass);
                                Double                      rating          =   roleScoreMap.get(factorClass).get2();
                        %>
                                <div class="appli-row">
                                    <span class="appli-label"><oneit:toString   value="<%= factorClass %>"   mode="EscapeHTML"/></span>
                                    <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                    <span class="appli-progress-bar">
                                        <div class="progress">
                                            <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%;"></div>
                                        </div>
                                    </span>
                                </div>
                            <%
                                if(detailed)
                                {
                                    for(FactorLevelLink factorLevelLink : factorDetails.keySet())
                                    {
                                        Map factorLinkDetails   =   factorDetails.get(factorLevelLink);

                                        if(!factorLinkDetails.isEmpty())
                                        {
                                            FactorScore factorScore =   (FactorScore) factorLinkDetails.get("factorScore");
                            %>
                                            <div class="tab-row">
                                                <div class="detail-tab-row-title">
                                                    <oneit:toString value="<%= factorLevelLink.getFactor() %>"  mode="EscapeHTML"/>
                                                </div>
                                                <div class="tab-view-side">
                                                    <div class="result-want">
                                                        <div class="result"><oneit:toString value="<%= factorLevelLink.getLeftAnnot() %>"   mode="EscapeHTML"/></div>
                                                        <div class="wants"><oneit:toString  value="<%= factorLevelLink.getRightAnnot() %>"  mode="EscapeHTML"/></div>
                                                        <div style="clear: both"></div>
                                                    </div>
                                                    <div class="result-bar">
                                                        <ul>
                                                        <%
                                                            Map<FactorScoreResult, Double>  factorScoreDetails  =   (Map<FactorScoreResult, Double>)factorLinkDetails.get("factorScoreDetails");

                                                            for(FactorScoreResult factorScoreResult : factorScoreDetails.keySet())
                                                            {
                                                        %>
                                                                <li class="<%= factorScoreResult.getColorCode() != null ? factorScoreResult.getColorCode().getCSSClass() : "" %>"   style="width: <%= factorScoreDetails.get(factorScoreResult) %>%; height: 10px"></li>
                                                        <%
                                                            }
                                                        %>
                                                        </ul>
                                                        <span class="triangle-arrow" style="left: <%= factorLinkDetails.get("scoreLeftMargin")%>%;"></span>
                                                    </div>
                                                    <div class="like-strive"><oneit:toString    value="<%= factorScore != null ? factorScore.getNarrative() : null %>"  mode="EscapeHTML"/></div>
                                                </div>
                                            </div>
                        <%
                                        }
                                    }
                                }
                            }   
                        %>
                    </td>
                </tr>
            </table>
            
            <!--Culture Fit Data-->
            <table width="100%" cellspacing="0" cellpadding="0" class="charts-table">
                <tr>
                    <td class="chart-cell">
                        <div class="cell-title">Culture Fit</div>
                        <div>
                            <img src="file:///<%= jobApplication.getCultureRingChart() %>" alt="Ring Chart"/>
                        </div>
                        <div class="row four-label">
                        <%
                            List<Tuple.T2>  cultureConcerns =   jobApplication.getCultureAreaOfConcerns();

                            if(detailed && !cultureConcerns.isEmpty())
                            {
                                int rowCount    =   (cultureConcerns.size() % 2 == 0) ? (cultureConcerns.size() / 2) : ((cultureConcerns.size() + 1) / 2);
                                
                                for(int i = 0; i < rowCount; i++)
                                {
                                    Tuple.T2    firstTuple  =   cultureConcerns.get(i*2);
                                    Tuple.T2    secondTuple =   (cultureConcerns.size() > ((i*2) + 1)) ? cultureConcerns.get((i*2) + 1) : null;
                                    
                                    String      dotClass    =   ((ColorCode)firstTuple.get1()).getDotCSSClass();
                        %>
                                    <div class="a-label-row">
                                        <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + ((CultureElement)firstTuple.get0()).getObjectID() %>')">
                                            <span class="common-dot <%= dotClass %>"></span>
                                            <span class="r-y-label text-dot-dot">
                                                <oneit:toString value="<%= firstTuple.get0() %>"    mode="EscapeHTML"/>
                                            </span>
                                        </div>
                                    <%
                                        if(secondTuple != null)
                                        {
                                            dotClass    =   ((ColorCode)secondTuple.get1()).getDotCSSClass();
                                    %>
                                            <div class="col-md-6 col-sm-6 col-xs-6 text-left"   onClick="focusDiv('<%= "#" + ((CultureElement)firstTuple.get0()).getObjectID() %>')">
                                                <span class="common-dot <%= dotClass %>"></span>
                                                <span class="r-y-label text-dot-dot">
                                                    <oneit:toString value="<%= secondTuple.get0() %>"   mode="EscapeHTML"/>
                                                </span>
                                            </div>
                                    <%
                                        }
                                    %>
                                    </div>
                        <%
                                }
                            }
                        %>
                        </div>
                    </td>
                    <td class="chart-info-cell">
                       
                            <%
                                Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>    cultureFitData  =   (Map<CultureClass, Tuple.T2<Long, Set<Tuple.T3>>>) jobApplication.getCultureFit();
                            
                                for(CultureClass cClass: cultureFitData.keySet())
                                {
                                    if(cClass == null || cultureFitData.get(cClass) == null)
                                    {
                                        continue;
                                    }
                                
                                    Long    rating  =   cultureFitData.get(cClass).get0();
                            %>
                                    <div class="appli-row">
                                        <span class="appli-label"><oneit:toString   value="<%= cClass %>"   mode="EscapeHTML"/></span>
                                        <span class="appli-percen gray"><oneit:toString  value="<%= rating %>"   mode="PercentageWholeNumber" /></span>
                                        <span class="appli-progress-bar">
                                            <div class="progress">
                                                <div class="progress-bar" role="progressbar" aria-valuenow="<%= rating %>" aria-valuemin="0" aria-valuemax="100" style="width:<%= rating %>%;"></div>
                                            </div>
                                        </span>
                                    </div>
                                    <%
                                        if(detailed)
                                        {
                                            for(Tuple.T3 tuple : cultureFitData.get(cClass).get1())
                                            {
                                                CultureNarrative    cultureNarrative    =   (CultureNarrative) tuple.get2();
                                                String              dotClass            =   cultureNarrative != null && cultureNarrative.getColorCode() != null ? cultureNarrative.getColorCode().getDotCSSClass() : "";
                                    %>
                                                <div class="tab-row fixed-height" id="<%= ((CultureElement)tuple.get1()).getObjectID() %>">
                                                    <div class="detail-tab-row-title ">
                                                        <span class="common-dot <%= dotClass %>"></span> &nbsp; 
                                                        <oneit:toString value="<%= tuple.get1() %>" mode="EscapeHTML"/>
                                                    </div>
                                                    <div class="detail-tab-row-text line-height-fixed">
                                                        <oneit:toString value="<%= cultureNarrative %>" mode="EscapeHTML"/>
                                                    </div>
                                                </div>
                                    <%
                                            }
                                        }
                                }
                            %>
                       
                    </td>
                </tr>
            </table>
        </div>        
    </div>
</oneit:dynIncluded>