
-- @AutoRun
-- drop table tl_hiring_team;



CREATE TABLE tl_hiring_team (
    object_id numeric(12) NOT NULL ,
    object_last_updated_date timestamp DEFAULT NOW() NOT NULL ,
    object_created_date timestamp DEFAULT NOW() NOT NULL
    ,
    hiring_team_name varchar(100) NOT NULL,
    hiring_team_logo bytea NULL,
    hiring_team_type varchar(200) NULL,
    industry varchar(200) NULL,
    time_zone varchar(200) NULL,
    state varchar(200) NULL,
    country varchar(200) NULL,
    post_code varchar(10) NULL,
    city varchar(100) NULL,
    has_client_support char(1) NULL,
    manage_own_billing char(1) NULL,
    stripe_reference varchar(100) NULL,
    stripe_subscription varchar(100) NULL,
    stripe_fixed_sub_item varchar(100) NULL,
    stripe_metered_sub_item varchar(100) NULL,
    name_on_card varchar(100) NULL,
    card_post_code varchar(10) NULL,
    card_id varchar(100) NULL,
    plan_renewed_on timestamp NULL,
    used_credits numeric(12) NULL,
    available_credits numeric(12) NULL,
    is_ppj char(1) NULL,
    has_cap char(1) NULL,
    max_cap numeric(12) NULL,
    coupon_expiry_date timestamp NULL,
    last_plan_amount numeric(20,5) NULL,
    company_id numeric(12)  NOT NULL,
    billing_team_id numeric(12)  NULL,
    added_by_user_id numeric(12)  NOT NULL,
    payment_plan_id numeric(12)  NULL,
    coupon_id numeric(12)  NULL
    );



ALTER TABLE tl_hiring_team ADD    
    CONSTRAINT pk_tl_hiring_team PRIMARY KEY 
    (
        object_id
    ) ;
    
    
    
    CREATE INDEX idx_tl_hiring_team_company_id 
    ON tl_hiring_team (company_id);

    CREATE INDEX idx_tl_hiring_team_billing_team_id 
    ON tl_hiring_team (billing_team_id);
