<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    Job     job         =   (Job) process.getAttribute("Job");
    String  nextPage    =   WebUtils.getSamePageInRenderMode(request, WebUtils.WORKPLACE_CULTURE);
    String  jobPage     =   WebUtils.getSamePageInRenderMode(request, "Page");

    Debug.assertion(job != null, "Job is null in admin portal create job");
%>
    <script>
        $(document).ready(function(){
            setupRecalc ($("form"), {'recalcOnError':true});
        });
    </script>
    <oneit:form name="editJob" method="post" enctype="multipart/form-data">
        
        <div class="container-fluid">
            
            <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>
            
            <h1 class="page-title">Create a job</h1>

            <oneit:dynInclude   page="/extensions/adminportal/inc/job_main_tabs.jsp"    PageNumber="2"    data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <%
                job.setCompletedAssessmentType(Boolean.TRUE);
            %>
            
            <div class="form-page-area main-job-match-area">
                <div class="create-job match-job">            
                    <div class="form-group">
                        <label class="label-16">Select your assessment type</label>                
                    </div>
                    
                <%
                    FormTag     jobForm             =   FormTag.getActiveFormTag(request);
                    FormBuilder formBuilder         =   jobForm.getFormBuilder();
                    String      assessmentTypeKey   =   WebUtils.getInputKey(request, job, Job.FIELD_AssessmentType);
                    String      assessmentTypeValue =   formBuilder.fieldValue (assessmentTypeKey, job.getAssessmentType() == null ? "" : job.getAssessmentType().getName());

                    for(AssessmentType assessmentType : AssessmentType.getAssessmentTypeArray())
                    {
                        String  assessmentTypeId    =   assessmentType.getName();
                        String  selectedStr         =   CollectionUtils.equals(assessmentTypeValue, assessmentTypeId) ? "checked" : "";
                %>
                        <div class="radio radio-primary job-match-radio">
                            <input type="radio" name="<%= assessmentTypeKey %>" id="<%= assessmentTypeId %>"    class="type_radio" value="<%= assessmentType.getName() %>" <%= selectedStr %>/>
                            <label for="<%= assessmentTypeId %>">
                                <span class="label-title"><oneit:toString value="<%= assessmentType %>" mode="EscapeHTML" /></span>
                                <oneit:toString value="<%= assessmentType.getQuestionDetails() %>"  mode="EscapeHTML"/><br />
                            </label>
                        </div>
                <%
                    }
                    
                    String  levelKey    =   WebUtils.getRadioSingleAssocKey(request, job, Job.SINGLEREFERENCE_Level);
                    String  levelValue  =   formBuilder.fieldValue (levelKey, job.getLevel() == null ? "" : String.valueOf(job.getLevelID()));
            %>
                    <div class="main-pack-type">
                        <ul>
                        <%
                            for(Level level : Level.getAllLevels(transaction))
                            {
                                String  levelId     =   String.valueOf(level.getID().longID());
                                boolean isSelected  =   CollectionUtils.equals(levelId, levelValue);
                                String  selected    =   isSelected ? "checked" : "";
                                String  liClass     =   isSelected ? "active" : "";
                        %>
                                <oneit:recalcClass  htmlTag="li"    classScript="job.getLevelClass(level)"  job="<%= job %>"    level="<%= level %>">
                                    <a href="javascript:void(0)">
                                        <input type="radio" name="<%= levelKey %>" id="<%= levelId %>"  class="level_radio" value="<%= levelId %>" <%= selected %>/>
                                        <label for="<%= levelId %>">
                                            <span class="talen">Talentology</span>
                                            <span class="pack-type"><oneit:toString value="<%= level %>"    mode="EscapeHTML" /></span>
                                            <span class="pack-img <%= level.getCSSClass() %>"></span>
                                        </label>
                                    </a>
                                </oneit:recalcClass>
                        <%
                            }
                        %>
                        </ul>
                    </div>
                    <div class="clearfix"></div>
                    <div class="text-center">
                        <oneit:button   value="Save as draft"   name="saveJob"  cssClass="btn btn-primary top-margin-37 largeBtn greyBtn"
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", jobPage)
                                                                            .mapEntry(UpdateMappedObjFP.FAIL_VALIDATION_ERRORS, Boolean.FALSE)
                                                                            .toMap() %>"/>
                        <oneit:button   value="Proceed to Culture"    name="processCulture" cssClass="btn btn-primary top-margin-37 largeBtn" 
                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("Job", job).toMap())
                                                                        .mapEntry("fromJobMatch", true)
                                                                        .toMap() %>"/>
                    </div>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>