/**
 * Reference : https://stripe.com/docs/stripe-js#elements
 */

// Create a Stripe client
var stripe = Stripe(stripePubKey);

// Create an instance of Elements
var elements = stripe.elements();

// Custom styling can be passed to options when creating an Element.
var style = {
  base: {
    // Add your base input styles here. For example:
    fontSize: '18px',
    fontFamily: '"Usual-Light"',
    color: "#555",
    '::placeholder': {
        color: '#DBDBDF',
        fontSize: '18px',
    },
//    padding-top: "7px !important",
  }
};

var cardNumber = elements.create('cardNumber', {style: style, placeholder: ''});
cardNumber.mount('#card-number');

var cardExpiry = elements.create('cardExpiry', {style: style});
cardExpiry.mount('#card-expiry');

var cardCvc = elements.create('cardCvc', {style: style, placeholder: ''});
cardCvc.mount('#card-cvc');

cardNumber.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});
cardExpiry.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});
cardCvc.addEventListener('change', function(event) {
  var displayError = document.getElementById('card-errors');
  if (event.error) {
    displayError.textContent = event.error.message;
  } else {
    displayError.textContent = '';
  }
});

// Create a token or display an error when the form is submitted.
var form = document.getElementById('makePayment');

form.addEventListener('submit', function(event) {
    event.preventDefault();

    var nameOnCard  = document.getElementById('NameOnCard').value;
    var postalCode  = document.getElementById('PostCode').value;
    
    stripe.createToken(cardNumber, {name: nameOnCard, address_zip : postalCode}).then(function(result) {
        if (result.error) {
            // Inform the customer that there was an error
            var errorElement = document.getElementById('card-errors');
            errorElement.textContent = result.error.message;
        } else {
            // Send the token to your server
            $('input[name=stripe-token-id]').val(result.token.id);
            $('#payNow').click();
        }
    });
});