<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<oneit:dynIncluded>
<%
    String              currentPage     =   WebUtils.getSamePageInRenderMode(request, "CoverLetter");
    String              nextPage        =   WebUtils.getSamePageInRenderMode(request, "SubmitApplication");
    ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
    Long                jobAppId        =   process.getAttribute("JobApplicationID") != null ? 
                                                (Long) process.getAttribute("JobApplicationID") :
                                                ((JobApplication) process.getAttribute("JobApplication")).getID().longValue();
    JobApplication      jobApplication  =   null;

    if(jobAppId != null)
    {
        jobApplication  =   JobApplication.getJobApplicationByID(objTran, jobAppId);
    }

    if(jobApplication == null)
    {
        jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
    }

    Debug.assertion(jobApplication != null, "Job Application cannot be null in applicant  portal - cv and cover letter ");
      
    Job     job =   jobApplication.getJob();

    if(process.getAttribute("JobApplicationID") == null)
    {
        process.setAttribute("JobApplicationID" , jobApplication.getID().longValue());
    }

    if(!jobApplication.selectionCompleted())
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "SelectionCriteria");
    }
    else if(!jobApplication.cultureCompleted())
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    }
    else if(!jobApplication.assessmentCompleted())
    {
        nextPage    =   WebUtils.getSamePageInRenderMode(request, "JobMatchAssessment");
    }
%>
    <div class="apply-job-logo-header signinpage">
        <div>
            <div class="logo-img">
            <%
                BinaryContent   logo    =   job.getLogo();

                if(logo != null)
                {
                    int logoHeight  =   45;
            %>
                    <tagfile:img src="<%= ThumbnailUtils.filterImage(DiskFileBinaryContent.getRelativeURL(logo), "KEEP", new ScaleWithin (0, logoHeight)) %>" />
            <%
                }
            %>
            </div>
            <div class="header-title">
                <%= job.getTeamName() %>
            </div>
        </div>
    </div>
    <oneit:form name="editApplication"  method="post"   enctype="multipart/form-data">
        <oneit:dynInclude   page="/extensions/applicantportal/inc/multifieldtext.jsp"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

        <div class="main-verify-identity">
            <div class="pl-confirm text-center">Great! Now let's attach your CV and Cover Letter</div>
            <div class="main-box-layout main-verify-step-2">
                <div class="form-group text-left">
                    <label>Upload your CV</label>
                    <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CV"          cssClass="form-control second-style"/>
                </div>
                <div class="form-group text-left">
                    <label>Upload your Cover Letter</label>
                    <oneit:ormInput obj="<%= jobApplication %>" type="file" attributeName="CoverLetter" cssClass="form-control second-style"/>
                </div>

                <div class="text-center">
                    <oneit:button   value="Attach and proceed"    name="validateApplication"   cssClass="box-btn show-mobile"
                                                        requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                                        .mapEntry("fromCoverLetter", true)
                                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                        .toMap() %>"/>
                </div>
            </div>
        </div>
    </oneit:form>
    
</oneit:dynIncluded>