<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>

<%@ include file="inc/htmlheader_nopriv.jsp" %>

<oneit:dynIncluded>

<%
    String      nextPage    =   WebUtils.getSamePageInRenderMode(request, "InviteUsers");  
    Company     company     =   (Company) process.getAttribute("Company");
    
    Debug.assertion(company != null, "Invalid company user in admin portal");

    CompanyUser companyUser =   company.getAddedByUser();
    SecUser     secUser     =   companyUser.getUser();
    Integer     pageNumber  =   1;
    
    process.setAttribute("Company", company);
%>

<div class="hire-the-right-candi" style="height: 77px">Hello, <%= secUser.getFirstName() %></div>

<div class="section-tab-view">
    <div class="main-tab-form">
        <ul class="nav nav-pills nav-justified">
            <li class="active">
                <a href="#">
                    <span>1</span>
                    <div>Company Profile</div>
                </a>
            </li>
            <li class="2">
                <a href="#">
                    <span>2</span>
                    <div>Invite Users</div>
                </a>
            </li>
            <li class="">
                <a href="#">
                    <span>3</span>
                    <div>Create a Job</div>
                </a>
            </li>
        </ul>
    </div>
    
    <oneit:form name="companyProfile" method="post" enctype="multipart/form-data">
        <div class="section-page-area"  style="text-align: left">
            <div class="main-sc-section">
                <div class="form-group">
                    <label><oneit:label GUIName="What type of hiring team are you?" /></label>
                    <%
                        FormTag     jobForm     =   FormTag.getActiveFormTag(request);
                        FormBuilder formBuilder =   jobForm.getFormBuilder();
                        String      optionKey   =   WebUtils.getInputKey(request, company, Company.FIELD_HiringTeamType);
                        String      formValue   =   formBuilder.fieldValue (optionKey, company.getHiringTeamType() == null ? "" : company.getHiringTeamType().getName());

                        for(HiringTeamType hiringTeamType : HiringTeamType.getHiringTeamTypeArray())
                        {
                            boolean isSelected          =   CollectionUtils.equals(formValue, hiringTeamType.getName());
                            String  hiringTeamTypeId    =   String.valueOf(company.getID().longID()) + "_hiringteamtype_" + hiringTeamType.getName();
                            String  selected            =   isSelected ? "checked" : "";
                            String  activeClass         =   isSelected ? "active" : "";
                    %>
                            <div    class="<%= "radio radio-primary workplace-radio " %>">
                                <input  type="radio"    name="<%= optionKey %>"    id="<%= hiringTeamTypeId %>"    class="element_rating_radio" value="<%= hiringTeamType.getName() %>" <%= selected %> >
                                <label  for="<%= hiringTeamTypeId %>">
                                    <oneit:toString value="<%= hiringTeamType %>"   mode="EscapeHTML"/>
                                </label>
                            </div>
                    <%
                        }
                    %>
                </div>

                <div class="form-group">
                    <label><oneit:label GUIName="Industry" /></label>
                    <oneit:ormEnum  obj="<%= company %>"    attributeName="Industry"    cssClass="form-control"/>
                </div>

                <div class="form-group">
                    <label><oneit:label GUIName="Time zone" /></label>
                    <oneit:ormEnum  obj="<%= company %>"    attributeName="TimeZone"    cssClass="form-control"/>
                </div>

                <div class="form-group  content-to-center">
                    <oneit:button   value="Confirm details & invite users"  name="gotoPage"   cssClass="box-btn send-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                        .mapEntry("procParams", CollectionUtils.mapEntry("pageNumber", 2).toMap())
                                                                        .toMap() %>"/>
                </div>
            </div>
        </div>
    </oneit:form>
</div>

</oneit:dynIncluded>

<%@ include file="inc/htmlfooter_nopriv.jsp" %>