<%@ page extends="oneit.servlets.jsp.JSPInclude"%>

<%@ taglib prefix="tagfile" tagdir="/WEB-INF/tags"%>
<%@ include file="/setuprequest.jsp"%>

<%@ page import="oneit.servlets.process.*"%>
<%@ page import="oneit.objstore.*, oneit.utils.*, oneit.utils.text.*"%>
<%@ page import="java.util.*"%>
<%@ page import="performa.orm.*, performa.orm.types.*, performa.chart.*, performa.utils.*"%>
<%
    ORMProcessState         process         =   (ORMProcessState) ProcessDecorator.getDefaultProcess(request);
    ObjectTransaction       objTran         =   process.getTransaction();
    Job                     job             =   (Job) process.getAttribute("Job");
    List<JobApplication>    applications    =   (List<JobApplication>) getData(request, "Applications");
    WorkFlow                workFlow        =   (WorkFlow) getData(request, "WorkFlow");
%>
<oneit:dynIncluded>
    <div class="wrap">
        <div class="header">
            <div class="chief-officer">
                <oneit:toString value="<%= job.getJobTitle() %>"    mode="EscapeHTML" />
                <%
                    if(job.getReferenceNumber() != null)
                    {
                %>
                &nbsp;<span class="ref-no">(<oneit:toString value="<%= job.getReferenceNumber() %>" mode="EscapeHTML" />)</span>
                <%
                    }
                %>
            </div>
            <div class="by-name">
                <div class="header-right-status">
                    <span class="light-calendar">
                        <%
                            if(job.getJobStatus() == JobStatus.OPEN)
                            {
                                int daysToClose =   job.getNoOfDaystoClosed();
                        %>
                                <span class="number">
                                    <oneit:toString value="<%= daysToClose %>"  mode="Integer"/>
                                </span>
                                <oneit:toString value="<%= (daysToClose == 1 ? "day" : "days") + " until closed" %>"    mode="EscapeHTML"/>
                        <%
                            }
                            else
                            {
                        %>
                                <oneit:toString value="<%= job.getJobStatus().getDescription() %>"    mode="EscapeHTML"/> on
                                <oneit:toString value="<%= job.getLastStatusChangeDate() %>"    mode="PerformaDate"/>
                        <%
                            }
                        %>
                    </span>
                    <span class="job-status-appli">
                        <span class="<%= job.getJobStatus().getName().toLowerCase() + "-status-icon" %>"></span>
                        <oneit:toString  value="<%= job.getJobStatusText() %>"    mode="EscapeHTML"/>
                    </span>
                </div>
                <span class="austr-post">
                <%
                    if(job.isClientAvailable())
                    {
                %>
                        <oneit:toString value="<%= job.getClient() %>"  mode="EscapeHTML" />
                <%
                    }
                %>
                </span> by <oneit:toString   value="<%= job.getCreatedBy() %>"  mode="EscapeHTML"  nullValue=""/>
                &nbsp;&nbsp;.&nbsp;&nbsp;
                <oneit:toString value="<%= job.getOccupation() %>"   mode="EscapeHTML" />
            </div>
        </div>
        <div class="white-header">
            <div style="clear:both"></div>

            <div class="main-appli-name">
                <div class="appli-name"><%= workFlow == null || workFlow.getApplicationStatus() == ApplicationStatus.SUBMITTED ? "All" : workFlow.getName() %> Applicants </div>
            </div>
            <div class="appli-count">
                <%= applications.size() %> Applicants
            </div>
        </div>  
        <div class="view-appli-list">
    <%
        for (JobApplication jobApplication : applications)
        {
            String  roleFit     =   FormatUtils.stringify(jobApplication.getRoleFitPercentage(), "PercentageWholeNumber", "0");
            String  culture     =   FormatUtils.stringify(jobApplication.getCultureFitScore(), "PercentageWholeNumber", "0");
            Integer overallRank =   jobApplication.getOverallRank();
            boolean missingReq  =   jobApplication.hasFailedEssentialRequirements();
    %>
    
            <div class="appl-c-box">
                <div class="gridbox-title">
                    <div class="gridbox-applicant">
                        <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                    </div>
                </div>
                <div class="overall-suitablity">
                    <div class="overall">overall rank</div>
                    <div class="over-all blue">
                        <oneit:toString value="<%= overallRank %>"   mode="Integer" />
                    </div>
                     <div style="clear:both"></div>
                </div>
                <div class="jcc-box">
                    <div class="job-match jcc">
                        <div class="jcc-title">
                        <img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/job-match-icon.png" /> role fit 
                        </div>
                       <div class="jcc-precentage">
                            <oneit:toString value="<%= jobApplication.getRoleFitPercentage() %>"    mode="PercentageWholeNumber" />
                        </div>
                    </div>
                    <div class="culture jcc">
                         <div class="jcc-title">
                        <img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/culture-icon.png" /> culture fit
                         </div>
                         <div class="jcc-precentage">
                            <oneit:toString value="<%= jobApplication.getCultureFitScore() %>"  mode="PercentageWholeNumber" />
                        </div>
                    </div>
                        
                    <%
                        if(job.getIncludeAssessmentCriteria()==Boolean.TRUE)
                        {
                    %>
                            <div class="criteria jcc <%=(missingReq ? "red-bg" : "green-bg")%> ">
                                <div class="jcc-title">
                                <img src="file:///<%= PDFUtils.FILE_BASE_PATH %>/images/<%=(missingReq ? "icon-requirements_small.png" : "critarea_white.png")%>"/> requirements
                                </div>
                               <div class="jcc-precentage">
                                    <oneit:toString value="<%= jobApplication.getRequirementFitScore() %>"  mode="PercentageWholeNumber" />
                                </div>
                            </div>
                    <%
                        }
                    %>
                     <div style="clear:both"></div>
                </div>
            </div>
    <%
        }
    %>
   
    </div>
      </div>
</oneit:dynIncluded>