
package performa.orm;

import java.io.*;
import java.util.*;
import java.sql.ResultSet;
import java.sql.SQLException;
import oneit.logging.*;
import oneit.objstore.*;
import oneit.objstore.assocs.*;
import oneit.objstore.rdbms.*;
import oneit.objstore.utils.*;
import oneit.sql.*;
import oneit.utils.resource.*;
import oneit.utils.*;
import oneit.utils.threading.*;
import performa.orm.types.*;



/**
 * IMPORTANT!!!! Autogenerated class, DO NOT EDIT!!!!!
 * Template: Infrastructure8.2[oneit.objstore.PersistenceMgrTemplate.xsl]
 */
public class WorkFlowTemplatePersistenceMgr extends ObjectPersistenceMgr
{
    private static final LoggingArea WorkFlowTemplatePersistence = LoggingArea.createLoggingArea(ObjectPersistenceMgr.OBJECT_PERSISTENCE, "WorkFlowTemplate");

    // Private attributes corresponding to business object data
    private String dummyTemplateName;
    private String dummyLandingButtonText;
    private String dummyVerificationHeaderText;
    private Boolean dummyCaptureCV;
    private Boolean dummyIsCVMandatory;
    private Boolean dummyCaptureCL;
    private Boolean dummyIsCLMandatory;
    private String dummyApplicationButtonText;
    private ResponseAction dummyApplicationResponseAction;
    private String dummyThankYouHeaderText;
    private String dummyThankYouSecondaryText;
    private String dummyJobOutlineButtonText;
    private Boolean dummyIsGlobalTemplate;
    private Boolean dummyIsSystemGenerated;
    

    // Static constants corresponding to attribute helpers
    private static final DefaultAttributeHelper HELPER_TemplateName = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_LandingButtonText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_VerificationHeaderText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CaptureCV = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsCVMandatory = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_CaptureCL = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsCLMandatory = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ApplicationButtonText = DefaultAttributeHelper.INSTANCE;
    private static final EnumeratedAttributeHelper HELPER_ApplicationResponseAction = new EnumeratedAttributeHelper (ResponseAction.FACTORY_ResponseAction);
    private static final DefaultAttributeHelper HELPER_ThankYouHeaderText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_ThankYouSecondaryText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_JobOutlineButtonText = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsGlobalTemplate = DefaultAttributeHelper.INSTANCE;
    private static final DefaultAttributeHelper HELPER_IsSystemGenerated = DefaultAttributeHelper.INSTANCE;
    



    public WorkFlowTemplatePersistenceMgr ()
    {
        dummyTemplateName = (String)(HELPER_TemplateName.initialise (dummyTemplateName));
        dummyLandingButtonText = (String)(HELPER_LandingButtonText.initialise (dummyLandingButtonText));
        dummyVerificationHeaderText = (String)(HELPER_VerificationHeaderText.initialise (dummyVerificationHeaderText));
        dummyCaptureCV = (Boolean)(HELPER_CaptureCV.initialise (dummyCaptureCV));
        dummyIsCVMandatory = (Boolean)(HELPER_IsCVMandatory.initialise (dummyIsCVMandatory));
        dummyCaptureCL = (Boolean)(HELPER_CaptureCL.initialise (dummyCaptureCL));
        dummyIsCLMandatory = (Boolean)(HELPER_IsCLMandatory.initialise (dummyIsCLMandatory));
        dummyApplicationButtonText = (String)(HELPER_ApplicationButtonText.initialise (dummyApplicationButtonText));
        dummyApplicationResponseAction = (ResponseAction)(HELPER_ApplicationResponseAction.initialise (dummyApplicationResponseAction));
        dummyThankYouHeaderText = (String)(HELPER_ThankYouHeaderText.initialise (dummyThankYouHeaderText));
        dummyThankYouSecondaryText = (String)(HELPER_ThankYouSecondaryText.initialise (dummyThankYouSecondaryText));
        dummyJobOutlineButtonText = (String)(HELPER_JobOutlineButtonText.initialise (dummyJobOutlineButtonText));
        dummyIsGlobalTemplate = (Boolean)(HELPER_IsGlobalTemplate.initialise (dummyIsGlobalTemplate));
        dummyIsSystemGenerated = (Boolean)(HELPER_IsSystemGenerated.initialise (dummyIsSystemGenerated));
        
    }

    private String  SELECT_COLUMNS = "{PREFIX}tl_work_flow_template.object_id as id, {PREFIX}tl_work_flow_template.object_LAST_UPDATED_DATE as LAST_UPDATED_DATE, {PREFIX}tl_work_flow_template.object_CREATED_DATE as CREATED_DATE, {PREFIX}tl_work_flow_template.template_name, {PREFIX}tl_work_flow_template.landing_button_text, {PREFIX}tl_work_flow_template.verification_header_text, {PREFIX}tl_work_flow_template.capture_cv, {PREFIX}tl_work_flow_template.is_cv_mandatory, {PREFIX}tl_work_flow_template.capture_cl, {PREFIX}tl_work_flow_template.is_cl_mandatory, {PREFIX}tl_work_flow_template.application_button_text, {PREFIX}tl_work_flow_template.application_response_action, {PREFIX}tl_work_flow_template.thank_you_header_text, {PREFIX}tl_work_flow_template.thank_you_secondary_text, {PREFIX}tl_work_flow_template.job_outline_button_text, {PREFIX}tl_work_flow_template.is_global_template, {PREFIX}tl_work_flow_template.is_system_generated, {PREFIX}tl_work_flow_template.withdrawal_message_id, {PREFIX}tl_work_flow_template.hiring_team_id,  1 AS commasafe ";
    private String SELECT_JOINS = "";

    public BaseBusinessClass fetchByID(ObjectID id, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    resultByIDs = fetchByIDs(Collections.singleton (id), allPSets, context, sqlMgr);

        if (resultByIDs.isEmpty ())
        {
            return null;
        }
        else if (resultByIDs.size () > 1)
        {
            throw new StorageException ("Multiple results for id:" + id);
        }
        else
        {
            return resultByIDs.iterator ().next ();
        }
    }



    public Set<BaseBusinessClass> fetchByIDs(Set<ObjectID> ids, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        Set<BaseBusinessClass>    results = new HashSet ();
        Set<Long> idsToFetch = new HashSet ();

        for (ObjectID id : ids)
        {
            if (context.containsObject(id)) // Check for cached version
            {
                BaseBusinessClass objectToReturn = context.getObjectToReplace(id, WorkFlowTemplate.REFERENCE_WorkFlowTemplate);

                if (objectToReturn instanceof WorkFlowTemplate)
                {
                    LogMgr.log (WorkFlowTemplatePersistence, LogLevel.TRACE, "Cache hit for id:", id);
                    results.add (objectToReturn);
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + id + " with object " + objectToReturn + "while fetching a WorkFlowTemplate");
                }
            }

            PersistentSet tl_work_flow_templatePSet = allPSets.getPersistentSet(id, "tl_work_flow_template", PersistentSetStatus.FETCHED);
            
            

             // Check for persistent sets already prefetched
            if (false  || !tl_work_flow_templatePSet.containsAttrib(BaseBusinessClass.FIELD_ObjectLastModified) ||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_TemplateName)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_LandingButtonText)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_VerificationHeaderText)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_CaptureCV)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_IsCVMandatory)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_CaptureCL)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_IsCLMandatory)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_ApplicationButtonText)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_ApplicationResponseAction)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_ThankYouHeaderText)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_ThankYouSecondaryText)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_JobOutlineButtonText)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_IsGlobalTemplate)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.FIELD_IsSystemGenerated)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.SINGLEREFERENCE_WithdrawalMessage)||
                    !tl_work_flow_templatePSet.containsAttrib(WorkFlowTemplate.SINGLEREFERENCE_HiringTeam))
            {
                // We will need to retrieve it
                idsToFetch.add (id.longValue());
            }
            else
            {
                LogMgr.log (WorkFlowTemplatePersistence, LogLevel.DEBUG2, "Persistent set preloaded id:", id);
        
                /* Non Polymorphic */
                WorkFlowTemplate result = new WorkFlowTemplate ();

                result.setFromPersistentSets(id, allPSets);
                context.addRetrievedObject(result);

                results.add (result);
            
            }
        }

        if (idsToFetch.size () > 0)
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_work_flow_template " +
                            "WHERE " + SELECT_JOINS + "{PREFIX}tl_work_flow_template.object_id IN ?";

            BaseBusinessClass[] resultsFetched = loadQuery (allPSets, sqlMgr, context, query, new Object[] { idsToFetch }, null, false);

            for (BaseBusinessClass objFetched : resultsFetched)
            {
                results.add (objFetched);
            }
        }


        return results;
    }



    public BaseBusinessClass[] getReferencedObjects(ObjectID _objectID, String refName, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        if (false)
        {
            throw new RuntimeException ();
        }
        else if (refName.equals (WorkFlowTemplate.SINGLEREFERENCE_HiringTeam))
        {
            String  query = "SELECT " + SELECT_COLUMNS +
                            "FROM {PREFIX}tl_work_flow_template " +
                            "WHERE " + SELECT_JOINS + "hiring_team_id = ?";

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, new Object[] { _objectID.longID () }, null, false);

            return results;
        }
        else
        {
            throw new IllegalArgumentException ("Illegal reference type:" + refName);
        }
    }



    public void update(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        EqualityResult  test = EqualityResult.compare (obj, obj.getBackup ());
        ObjectID        objectID = obj.getID ();

        if (!test.areAttributesEqual () || !test.areSingleAssocsEqual () || obj.getForcedSave())
        {
            PersistentSet tl_work_flow_templatePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_template");
            

            
            if (tl_work_flow_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
                tl_work_flow_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
            {
                int rowsUpdated = executeStatement (sqlMgr, 
                                                           "UPDATE {PREFIX}tl_work_flow_template " +
                                                           "SET template_name = ?, landing_button_text = ?, verification_header_text = ?, capture_cv = ?, is_cv_mandatory = ?, capture_cl = ?, is_cl_mandatory = ?, application_button_text = ?, application_response_action = ?, thank_you_header_text = ?, thank_you_secondary_text = ?, job_outline_button_text = ?, is_global_template = ?, is_system_generated = ?, withdrawal_message_id = ? , hiring_team_id = ?  , object_LAST_UPDATED_DATE = " + sqlMgr.getPortabilityServices ().getTimestampExpression () + " " +
                                                                
                                                           "WHERE tl_work_flow_template.object_id = ? AND " + getConcurrencyCheck (sqlMgr, "object_LAST_UPDATED_DATE", obj.getObjectLastModified ()) + " ",
                                                           CollectionUtils.listEntry (HELPER_TemplateName.getForSQL(dummyTemplateName, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_TemplateName))).listEntry (HELPER_LandingButtonText.getForSQL(dummyLandingButtonText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_LandingButtonText))).listEntry (HELPER_VerificationHeaderText.getForSQL(dummyVerificationHeaderText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_VerificationHeaderText))).listEntry (HELPER_CaptureCV.getForSQL(dummyCaptureCV, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_CaptureCV))).listEntry (HELPER_IsCVMandatory.getForSQL(dummyIsCVMandatory, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsCVMandatory))).listEntry (HELPER_CaptureCL.getForSQL(dummyCaptureCL, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_CaptureCL))).listEntry (HELPER_IsCLMandatory.getForSQL(dummyIsCLMandatory, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsCLMandatory))).listEntry (HELPER_ApplicationButtonText.getForSQL(dummyApplicationButtonText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ApplicationButtonText))).listEntry (HELPER_ApplicationResponseAction.getForSQL(dummyApplicationResponseAction, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ApplicationResponseAction))).listEntry (HELPER_ThankYouHeaderText.getForSQL(dummyThankYouHeaderText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ThankYouHeaderText))).listEntry (HELPER_ThankYouSecondaryText.getForSQL(dummyThankYouSecondaryText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ThankYouSecondaryText))).listEntry (HELPER_JobOutlineButtonText.getForSQL(dummyJobOutlineButtonText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_JobOutlineButtonText))).listEntry (HELPER_IsGlobalTemplate.getForSQL(dummyIsGlobalTemplate, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsGlobalTemplate))).listEntry (HELPER_IsSystemGenerated.getForSQL(dummyIsSystemGenerated, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsSystemGenerated))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.SINGLEREFERENCE_WithdrawalMessage)))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.SINGLEREFERENCE_HiringTeam)))).listEntry (objectID.longID ()).listEntry (obj.getObjectLastModified ()).toList().toArray());

                if (rowsUpdated != 1)
                {
                    // Error, either a concurrency error or a not-exists error
                    ResultSet r = executeQuery (sqlMgr, 
                                                       "SELECT object_id, object_LAST_UPDATED_DATE FROM {PREFIX}tl_work_flow_template WHERE object_id = ?",
                                                       new Object[] { objectID.longID () });

                    if (r.next ())
                    {
                        Date                d = new java.util.Date (r.getTimestamp (2).getTime());
                        String              errorMsg = QueryBuilder.buildQueryString ("Concurrent update error:[?] for row:[?] objDate:[?] dbDate:[?]", 
                                                                         new Object[] { "tl_work_flow_template", objectID.longID (), obj.getObjectLastModified (), d },
                                                                         sqlMgr.getPortabilityServices ());
                                                                         
                        LogMgr.log (WorkFlowTemplatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new ConcurrentUpdateConflictException (obj, "tl_work_flow_template");
                    }
                    else
                    {
                        String  errorMsg = "Attempt to update nonexistent row in table:tl_work_flow_template for row:" + objectID + " objDate:" + obj.getObjectLastModified ();

                        LogMgr.log (WorkFlowTemplatePersistence, LogLevel.BUSINESS1, errorMsg);
                        throw new RuntimeException (errorMsg);
                    }
                }

                tl_work_flow_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
            }
            
        }
        else
        {
            LogMgr.log (WorkFlowTemplatePersistence, LogLevel.DEBUG1, "Skipping update since no attribs or simple assocs changed on ", objectID);
        }
    }



    public void delete(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, ConcurrentUpdateConflictException, StorageException
    {
        ObjectID        objectID = obj.getID ();
        PersistentSet tl_work_flow_templatePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_template");
        

        LogMgr.log (WorkFlowTemplatePersistence, LogLevel.DEBUG2, "Deleting:", objectID);

        
        if (tl_work_flow_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_work_flow_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            int rowsDeleted = executeStatement (sqlMgr, 
                                                       "DELETE " +
                                                       "FROM {PREFIX}tl_work_flow_template " +
                                                       "WHERE tl_work_flow_template.object_id = ? AND " + sqlMgr.getPortabilityServices ().getTruncatedTimestampColumn ("object_LAST_UPDATED_DATE") + " = " + sqlMgr.getPortabilityServices ().getTruncatedTimestampParam("?") + " ",
                                                       new Object[] { objectID.longID(), obj.getObjectLastModified () });

            if (rowsDeleted != 1)
            {
                // Error, either a concurrency error or a not-exists error
                ResultSet r = executeQuery (sqlMgr, 
                                                   "SELECT object_id FROM {PREFIX}tl_work_flow_template WHERE object_id = ?",
                                                   new Object[] { objectID.longID() });

                if (r.next ())
                {
                    throw new ConcurrentUpdateConflictException (obj, "tl_work_flow_template");
                }
                else
                {
                    String  errorMsg = "Attempt to delete nonexistent row in table:tl_work_flow_template for row:" + objectID;

                    LogMgr.log (WorkFlowTemplatePersistence, LogLevel.SYSTEMERROR1, errorMsg);
                    throw new RuntimeException (errorMsg);
                }
            }

            tl_work_flow_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }


    public ResultSet executeSearchQueryAll (SQLManager sqlMgr) throws SQLException
    {
        throw new RuntimeException ("NOT implemented: executeSearchQueryAll");
    }
    



    public BaseBusinessClass[] loadQuery (PersistentSetCollection allPSets, SQLManager sqlMgr, RDBMSPersistenceContext context, String query, Object[] params, Integer maxRows, boolean truncateExtra) throws SQLException, StorageException
    {
        LinkedHashMap<ObjectID, WorkFlowTemplate> results = new LinkedHashMap ();
        
        ResultSet   r = executeQuery (sqlMgr, query, params);

        while (r.next())
        {
            ThreadUtils.checkInterrupted ();
            
            ObjectID    objectID = new ObjectID (WorkFlowTemplate.REFERENCE_WorkFlowTemplate.getObjectIDSpace (), r.getLong ("id"));
            WorkFlowTemplate resultElement;

            if (maxRows != null && !results.containsKey (objectID) && results.size () >= maxRows)
            {
                if (truncateExtra)
                {
                    break;
                }
                else
                {
                    throw new SearchRowsExceededException ("Maximum rows exceeded:" + maxRows);
                }
            }

            if (context.containsObject(objectID))
            {
                BaseBusinessClass   cachedElement = context.getObjectToReplace(objectID, WorkFlowTemplate.REFERENCE_WorkFlowTemplate);

                if (cachedElement instanceof WorkFlowTemplate)
                {
                    LogMgr.log (WorkFlowTemplatePersistence, LogLevel.TRACE, "Cache hit for id:", objectID);
                    resultElement = (WorkFlowTemplate)cachedElement;
                }
                else
                {
                    throw new StorageException ("Cache collision for id:" + objectID + " with object " + cachedElement + "while fetching a WorkFlowTemplate");
                }
            }
            else
            {
                PersistentSet tl_work_flow_templatePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_template", PersistentSetStatus.FETCHED);
                
                createPersistentSetFromRS(allPSets, r, objectID);

                

                        resultElement = new WorkFlowTemplate ();

                        resultElement.setFromPersistentSets(objectID, allPSets);
                        context.addRetrievedObject(resultElement);

                
            }

            results.put (objectID, resultElement);
        }

        

        BaseBusinessClass[] resultsArr = new BaseBusinessClass[results.size ()];

        return results.values ().toArray (resultsArr);
    }



    public BaseBusinessClass[] find(String searchType, PersistentSetCollection allPSets, Hashtable criteria, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        LogMgr.log (WorkFlowTemplatePersistence, LogLevel.DEBUG2, "Search executing:", searchType, " criteria:", criteria);
        String  customParamFilter = (String)criteria.get (SEARCH_CustomFilter);
        String  customOrderBy = (String)criteria.get (SEARCH_OrderBy);
        String  customTables = (String)criteria.get (SEARCH_CustomExtraTables);
        Boolean  noCommaBeforeCustomExtraTables = (Boolean)criteria.get (SEARCH_CustomExtraTablesNoComma);

        if (searchType.equals (SEARCH_CustomSQL))
        {
            Set<ObjectID>                     processedIDs = new HashSet();
            SearchParamTransform    tx = new SearchParamTransform (criteria);
            Object[]                searchParams;

            customParamFilter = StringUtils.replaceParams (customParamFilter, tx);
            searchParams = tx.getParamsArray();

            if (customOrderBy != null) 
            {
                customOrderBy = " ORDER BY " + customOrderBy;
            }
            else
            {
                customOrderBy = "";
            }


            ResultSet   r;
            String      concatCustomTableWith = CollectionUtils.equals(noCommaBeforeCustomExtraTables, true) ?  " " : ", ";
            String      tables = StringUtils.subBlanks(customTables) == null ? " " : concatCustomTableWith + customTables + " ";


            String  query = "SELECT " + SELECT_COLUMNS +
                                    "FROM {PREFIX}tl_work_flow_template " + tables +
                                    "WHERE " + SELECT_JOINS + " " + customParamFilter + customOrderBy;

            BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, null, false);

            return results;
        }
        else if (searchType.equals (WorkFlowTemplate.SEARCH_All))
        {
            // Local scope for transformed variables
            {
                
            }


            
                String      orderBy = " ORDER BY tl_work_flow_template.object_id";
                String      tables = " ";
                Set<String> joinTableSet = new HashSet<String>();
                String      filter;
                Object[]    searchParams; // paramFilter: tl_work_flow_template.object_id is not null
                    String preFilter = "(tl_work_flow_template.object_id is not null)"
                                     + "  ";
                    
                    
                    preFilter += context.getLoadingAttributes ().getCustomSQL() ;
                    
                    SearchParamTransform tx = new SearchParamTransform (criteria);
                    
                    filter = StringUtils.replaceParams (preFilter, tx);
                    searchParams = tx.getParamsArray();
                

                Integer maxRows = context.getLoadingAttributes ().getMaxRows ();
                boolean truncateExtra = !context.getLoadingAttributes ().isFailIfMaxExceeded();
                String  query = "SELECT " + SELECT_COLUMNS +
                                        "FROM {PREFIX}tl_work_flow_template " +  tables + tableSetToSQL(joinTableSet) +
                                        "WHERE " + SELECT_JOINS + " " + filter + orderBy;
                

                BaseBusinessClass[] results = loadQuery (allPSets, sqlMgr, context, query, searchParams, maxRows, truncateExtra);

                return results;
            
        }
        
        else
        {
            throw new IllegalArgumentException ("Illegal search type:" + searchType);
            
            
        }
    }

    private void createPersistentSetFromRS(PersistentSetCollection allPSets, ResultSet r, ObjectID objectID) throws SQLException
    {
        PersistentSet tl_work_flow_templatePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_template", PersistentSetStatus.FETCHED);
        
            // Object Modified
            tl_work_flow_templatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectLastModified, r.getTimestamp ("LAST_UPDATED_DATE"));

            // Object Created
            tl_work_flow_templatePSet.setAttrib(BaseBusinessClass.FIELD_ObjectCreated, r.getTimestamp ("CREATED_DATE"));

        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_TemplateName, HELPER_TemplateName.getFromRS(dummyTemplateName, r, "template_name"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_LandingButtonText, HELPER_LandingButtonText.getFromRS(dummyLandingButtonText, r, "landing_button_text"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_VerificationHeaderText, HELPER_VerificationHeaderText.getFromRS(dummyVerificationHeaderText, r, "verification_header_text"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_CaptureCV, HELPER_CaptureCV.getFromRS(dummyCaptureCV, r, "capture_cv"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_IsCVMandatory, HELPER_IsCVMandatory.getFromRS(dummyIsCVMandatory, r, "is_cv_mandatory"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_CaptureCL, HELPER_CaptureCL.getFromRS(dummyCaptureCL, r, "capture_cl"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_IsCLMandatory, HELPER_IsCLMandatory.getFromRS(dummyIsCLMandatory, r, "is_cl_mandatory"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_ApplicationButtonText, HELPER_ApplicationButtonText.getFromRS(dummyApplicationButtonText, r, "application_button_text"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_ApplicationResponseAction, HELPER_ApplicationResponseAction.getFromRS(dummyApplicationResponseAction, r, "application_response_action"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_ThankYouHeaderText, HELPER_ThankYouHeaderText.getFromRS(dummyThankYouHeaderText, r, "thank_you_header_text"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_ThankYouSecondaryText, HELPER_ThankYouSecondaryText.getFromRS(dummyThankYouSecondaryText, r, "thank_you_secondary_text"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_JobOutlineButtonText, HELPER_JobOutlineButtonText.getFromRS(dummyJobOutlineButtonText, r, "job_outline_button_text"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_IsGlobalTemplate, HELPER_IsGlobalTemplate.getFromRS(dummyIsGlobalTemplate, r, "is_global_template"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.FIELD_IsSystemGenerated, HELPER_IsSystemGenerated.getFromRS(dummyIsSystemGenerated, r, "is_system_generated"));
        
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.SINGLEREFERENCE_WithdrawalMessage, r.getObject ("withdrawal_message_id"));
        tl_work_flow_templatePSet.setAttrib(WorkFlowTemplate.SINGLEREFERENCE_HiringTeam, r.getObject ("hiring_team_id"));
        
    }


    public void create(BaseBusinessClass obj, PersistentSetCollection allPSets, RDBMSPersistenceContext context, SQLManager sqlMgr) throws SQLException, StorageException
    {
        ObjectID    objectID = obj.getID ();
        PersistentSet tl_work_flow_templatePSet = allPSets.getPersistentSet(objectID, "tl_work_flow_template");
        

        
        if (tl_work_flow_templatePSet.getStatus () != PersistentSetStatus.PROCESSED &&
            tl_work_flow_templatePSet.getStatus () != PersistentSetStatus.DEFERRED)
        {
            executeStatement (sqlMgr, 
                                     "INSERT INTO {PREFIX}tl_work_flow_template " +
                                     "  (template_name, landing_button_text, verification_header_text, capture_cv, is_cv_mandatory, capture_cl, is_cl_mandatory, application_button_text, application_response_action, thank_you_header_text, thank_you_secondary_text, job_outline_button_text, is_global_template, is_system_generated,  withdrawal_message_id, hiring_team_id,  object_id, object_LAST_UPDATED_DATE, object_CREATED_DATE) " +
                                     "VALUES " +
                                     "  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?,   ?,  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ",  " + sqlMgr.getPortabilityServices ().getTimestampExpression () + ")",
                                     CollectionUtils.listEntry (HELPER_TemplateName.getForSQL(dummyTemplateName, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_TemplateName))).listEntry (HELPER_LandingButtonText.getForSQL(dummyLandingButtonText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_LandingButtonText))).listEntry (HELPER_VerificationHeaderText.getForSQL(dummyVerificationHeaderText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_VerificationHeaderText))).listEntry (HELPER_CaptureCV.getForSQL(dummyCaptureCV, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_CaptureCV))).listEntry (HELPER_IsCVMandatory.getForSQL(dummyIsCVMandatory, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsCVMandatory))).listEntry (HELPER_CaptureCL.getForSQL(dummyCaptureCL, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_CaptureCL))).listEntry (HELPER_IsCLMandatory.getForSQL(dummyIsCLMandatory, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsCLMandatory))).listEntry (HELPER_ApplicationButtonText.getForSQL(dummyApplicationButtonText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ApplicationButtonText))).listEntry (HELPER_ApplicationResponseAction.getForSQL(dummyApplicationResponseAction, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ApplicationResponseAction))).listEntry (HELPER_ThankYouHeaderText.getForSQL(dummyThankYouHeaderText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ThankYouHeaderText))).listEntry (HELPER_ThankYouSecondaryText.getForSQL(dummyThankYouSecondaryText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_ThankYouSecondaryText))).listEntry (HELPER_JobOutlineButtonText.getForSQL(dummyJobOutlineButtonText, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_JobOutlineButtonText))).listEntry (HELPER_IsGlobalTemplate.getForSQL(dummyIsGlobalTemplate, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsGlobalTemplate))).listEntry (HELPER_IsSystemGenerated.getForSQL(dummyIsSystemGenerated, tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.FIELD_IsSystemGenerated))) .listEntry (SQLManager.CheckNull((Long)(tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.SINGLEREFERENCE_WithdrawalMessage)))).listEntry (SQLManager.CheckNull((Long)(tl_work_flow_templatePSet.getAttrib (WorkFlowTemplate.SINGLEREFERENCE_HiringTeam)))) .listEntry (objectID.longID ()).toList().toArray());

            tl_work_flow_templatePSet.setStatus (PersistentSetStatus.PROCESSED);
        }
        
    }
}
