import { Injectable } from '@angular/core';
import { MessageService } from 'primeng/api';

@Injectable()

export class ToasterService {

  constructor(
    private messageService: MessageService
  ) { }

  error(txt, title = 'Error'): void {
    this.messageService.add({severity: 'error', summary: title, detail: txt, life: 3000});
  }

  success(txt, title = 'Success'): void {
    this.messageService.add({severity: 'success', summary: title, detail: txt, life: 3000});
  }

  warning(txt, title = 'Warning'): void {
    this.messageService.add({severity: 'warn', summary: title, detail: txt, life: 3000});
  }

  info(txt, title = 'Notification'): void {
    this.messageService.add({severity: 'info', summary: title, detail: txt, life: 3000});
  }
}
