package performa.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.servlets.forms.RedisplayResult;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.objstore.ORMFormProcessor;
import oneit.utils.BusinessException;
import performa.utils.PerformaEmailFetcher;


public class RunEmailFetcherFP  extends ORMFormProcessor
{
    @Override
    public SuccessfulResult processForm(ObjectTransaction objTran, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        LogMgr.log(PerformaEmailFetcher.LOG, LogLevel.PROCESSING1, "RunEmailFetcherFP called");
        
        List<String>    visitedNodes    =   new ArrayList<>();
        
        PerformaEmailFetcher.runEmailFetcher(visitedNodes);
        
        submission.getRequest().setAttribute("VisitedNodes", visitedNodes);
        
        return RedisplayResult.getInstance();
    }
}