package performa.form;

import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oneit.logging.*;
import oneit.objstore.ObjectTransaction;
import oneit.objstore.StorageException;
import oneit.objstore.parser.BusinessObjectParser;
import oneit.servlets.forms.*;
import oneit.servlets.process.*;
import oneit.utils.*;
import performa.intercom.utils.IntercomUtils;
import performa.orm.*;
import performa.orm.types.ApplicationStatus;
import performa.utils.AnalysisEngine;
 

public class CompleteApplicationFP extends SaveFP
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException 
    {
        HttpServletRequest  request         =   submission.getRequest();
        ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
        JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
        
        jobApplication  =   (JobApplication) jobApplication.getInTransaction (objTran);

        jobApplication.setApplicationStatus(ApplicationStatus.SUBMITTED);
        jobApplication.setSubmittedDate(new Date());
        
        AnalysisEngine.analyseAnswers(jobApplication.getCandidate(), jobApplication.getJob().getLevel(), jobApplication.getCompletedAnswers());
        
        if(jobApplication.hasFailedEssentialRequirements())
        {
            jobApplication.setApplicationStatus(ApplicationStatus.UNSUITABLE);
        }
        
        LogMgr.log(JobApplication.LOG, LogLevel.PROCESSING2, "Job Application Completed", jobApplication);
        
        // restarting process as custom attributes needs to be updated to intercom
        completeProcessRestartAndRestoreAttribs(process, request);
        
        jobApplication  = (JobApplication) process.getAttribute("JobApplication");

        // Update company in intercom
        if(jobApplication != null && jobApplication.getJob().getCompanyUser() != null)
        {
            IntercomUtils.updateCompany(jobApplication.getJob().getCompanyUser().getCompany());
        }
        
        return super.processForm(process, submission, params);
    }

    
    @Override
    public void validate(ORMProcessState process, SubmissionDetails submission, MultiException exceptions, Map params) throws StorageException 
    {
        HttpServletRequest  request         =   submission.getRequest();
        ObjectTransaction   objTran         =   ObjectTransaction.getTransaction();
        JobApplication      jobApplication  =   (JobApplication) process.getAttribute("JobApplication");
        
        if(!jobApplication.cultureCompleted())
        {
            BusinessObjectParser.assertFieldCondition(jobApplication.getCandidate().getCultureCriteriaAnswersCount()>0, jobApplication, JobApplication.FIELD_ObjectID, "completeCulture", exceptions, true, request);
        }
        
        if(jobApplication.isIncludeAssessmentCriteria())
        {
            JobApplication  application =   jobApplication.getInTransaction(objTran);
            
            BusinessObjectParser.assertFieldCondition(jobApplication.getJob().getAssessmentCriteriasCount() == application.getAssessmentCriteriaAnswersCount(), jobApplication, JobApplication.FIELD_ObjectID, "completeAssessment", exceptions, true, request);
        }
        
        super.validate(process, submission, exceptions, params);
    }
}