<%@ page extends="oneit.servlets.jsp.JSPInclude" %>
<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@ page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<div class="main-application-outline">
<%
    ObjectTransaction   objTran         = process.getTransaction ();
    String              nextPage        = WebUtils.getSamePageInRenderMode(request, "SelectionCriteria");
    Job                 job             = (Job) process.getAttribute("Job");
    Candidate           candidate       = Utils.getCandidateUser(transaction);
    JobApplication      jobApplication  = JobApplication.searchCandidateJob(objTran, candidate, job);

    if(jobApplication == null)
    {
        jobApplication  = JobApplication.createNewApplication(candidate, job);
    }
    
    if(!jobApplication.isIncludeAssessmentCriteria())
    {
        nextPage    = WebUtils.getSamePageInRenderMode(request, "WorkplaceCulture");
    }
    
    Boolean isSelectionComplete =   jobApplication.selectionCompleted();
    Boolean isCultureComplete   =   jobApplication.cultureCompleted();
    Boolean isAssesmentComplete =   jobApplication.assessmentCompleted();
    
    
    process.setAttribute("JobApplication", jobApplication);
    
%>
        <div class="welcome-aust-logo"><img src="images/australia-post.png" /></div>
        <div class="welcome-title">Welcome <oneit:toString value="<%= candidate.getFirstName() %>"/>, here's your application outline</div>
        <div class="appli-aust-title"><oneit:toString value="<%= job.getJobTitle() %>"  mode="EscapeHTML"/></div>
        <p class="appli-content">
            <oneit:toString value="<%= job.getJobDescription() %>"  mode="ParagraphHTML"    nullValue="-"/>
        </p>
        <div class="three-block">
            <div class="col-sm-4 col-xs-12 app-block eq-height">
                <div class="block-icon <%= isSelectionComplete ? "app-outline-complete" : "" %>">
                    <div class="<%= isSelectionComplete ? "app-outline-complete-icon" : "app-outline-selection-icon" %>"></div>
                </div>
                <div class="app-block-title">Requirements</div>
                <div class="estimated-time">Estimated time to complete: <span>5 mins</span></div>
                <p>
                    Lorem ipsum dolor sit amet,
                    consectetur adipiscing elit. Aenean
                    semper at magna a tristique. Ut ut
                    magna ut mauris sagittis placerat.
                    Suspendisse vitae tempus sem.
                </p>
              </div>
            <div class="col-sm-4 col-xs-12 app-block app-second-block eq-height">
                <div class="block-icon <%= isCultureComplete ? "app-outline-complete" : "" %>">
                    <div class="<%= isCultureComplete ? "app-outline-complete-icon" : "app-outline-culture-icon" %>"></div>
                </div>
                <div class="app-block-title">Culture</div>
                <div class="estimated-time">Estimated time to complete: <span>5 mins</span></div>
                <p>
                    Lorem ipsum dolor sit amet,
                    consectetur adipiscing elit. Aenean
                    semper at magna a tristique. Ut ut
                    magna ut mauris sagittis placerat.
                    Suspendisse vitae tempus sem.
                </p>
            </div>
            <div class="col-sm-4 col-xs-12 app-block eq-height last-border">
                <div class="block-icon <%= isAssesmentComplete ? "app-outline-complete" : "" %>">
                    <div class="<%= isAssesmentComplete ? "app-outline-complete-icon" : "app-outline-assesmet-icon" %>"></div>
                </div>
                <div class="app-block-title">Profile Assessment</div>
                <div class="estimated-time">Estimated time to complete: <span>20 mins</span></div>
                <p>
                    Lorem ipsum dolor sit amet,
                    consectetur adipiscing elit. Aenean
                    semper at magna a tristique. Ut ut
                    magna ut mauris sagittis placerat.
                    Suspendisse vitae tempus sem.
                </p>
            </div>
        </div>
    <%
        if(!job.isClosed() && jobApplication.getApplicationStatus()!=ApplicationStatus.SUBMITTED)
        {
            String  btnText =   "Resume the application";

            if(jobApplication.getStatus()==ObjectStatus.NEW)
            {
                btnText =   "Begin the application";
            }
    %>
            <oneit:form name="applyJob" method="post" enctype="multipart/form-data">
                <div class="app-out-btn">
                    <span>
                        <%
                            if(!(isSelectionComplete && isCultureComplete && isAssesmentComplete))
                            {
                        %>
                            Total time to complete: Approximately 40 minutes
                        <%
                            }
                        %>
                    </span>
                    <oneit:button   value="<%= btnText %>"  name="gotoPage" skin="link" cssClass="box-btn"
                                    requestAttribs="<%= CollectionUtils.mapEntry("nextPage", nextPage)
                                                                    .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                    .toMap() %>"/>
                </div>
            </oneit:form>
    <%
        }
        else
        {
            String  infoStr =   "Job is no longer accepting applications.";

            if(jobApplication.getApplicationStatus() == ApplicationStatus.SUBMITTED)
            {
                infoStr =   "Completed on " + FormatUtils.stringify(jobApplication.getSubmittedDate(), "MidDate", "") ;
            }
    %>
            <div class="app-out-btn">
                <span></span>
                <span style="float: right"><oneit:toString value="<%= infoStr %>"  mode="EscapeHTML"/></span>
            </div>
    <%
        }
    %>

<style>
    .power-footer {
        background-color:#fff;
    }
</style>

</div>
</oneit:dynIncluded>