<%@ page extends="oneit.servlets.jsp.JSPInclude" %>

<%@ include file="/inc/stdimports50.jsp" %><%-- This is in cougar --%>
<%@ include file="/inc/stdcms.jsp" %><%-- This is in cougar --%>
<%@ include file="/extensions/performa/inc/stdimports.jsp" %>
<%@page import="oneit.utils.text.FormatUtils"%>

<oneit:dynIncluded>
<%
    Job             job             = (Job) process.getAttribute("Job");

    if(job==null && request.getParameter("JobID")!=null)
    {
       job  =  Job.getJobByID(transaction, Long.parseLong(request.getParameter("JobID")));
       
       process.setAttribute("Job", job);
    }
    
    Debug.assertion(job != null, "Job is null in admin portal view applicants");
    
    String          applicationPage =   WebUtils.getSamePageInRenderMode(request, WebUtils.VIEW_APPLICATION);
    int             closingInDays   =   DateDiff.getDateDiff(Calendar.DATE, DateDiff.getToday(), job.getApplyBy());
    AppSortOption   appSortOpt      =   (AppSortOption) process.getAttribute("AppSortOption");

    if(request.getParameter("AppSortOption") != null)
    {
        appSortOpt  =   AppSortOption.forName((String) request.getParameter("AppSortOption"));
    }
    
    if(appSortOpt == null)
    {
        appSortOpt  =   AppSortOption.RANK;
    }
    
    JobApplication[]    applications =   (JobApplication[]) process.getAttribute("JobApplications");
            
    if(application==null)
    {
        applications =  JobApplication.SearchByAll()
                                    .andJob(new EqualsFilter<>(job))
                                    .andApplicationStatus(new NotEqualsFilter<>(ApplicationStatus.DRAFT))
                                    .search(transaction);
        
        process.setAttribute("JobApplications", applications);
    }
    
    List<JobApplication>    sortedApplications  =   applications!=null ? Utils.getApplicationsSorted(applications, appSortOpt) : new ArrayList<JobApplication>();
    
    process.setAttribute("AppSortOption", appSortOpt);
%>

    <script type="text/javascript">
        $(document).ready(function() 
        {
            recalcFunction = setupRecalc ($("form"), {'recalcOnError':true});
        });
        
        function gotoEditApplication (id) {
            $('.' + id).click();
        }
    </script>
    
    <oneit:form name="viewApplicants" method="post"    enctype="multipart/form-data">
        
        <div class="dashboard-content-area">
            <oneit:dynInclude   page="/extensions/adminportal/inc/applicant_view_tabs.jsp"  TabNumber="1"   data="<%= CollectionUtils.EMPTY_MAP%>"/>

            <div class="second-part view-app-area">
                <div class="five-boxs">
                    <%
                        int index   = 0;

                        for(JobApplication jobApplication : sortedApplications)
                        {
                    %>
                            <div class="appl-c-box application-row" onClick='gotoEditApplication("<%= jobApplication.getID() %>")'>
                                <oneit:button   value="EDIT"    name="gotoPage" cssClass="<%= jobApplication.getID() + " hidden"%>" skin="link"
                                                requestAttribs="<%= CollectionUtils.mapEntry("nextPage", applicationPage)
                                                                                .mapEntry("procParams", CollectionUtils.mapEntry("JobApplication", jobApplication).toMap())
                                                                                .toMap() %>"/>
                                <!--TODO: need to work on the logic. just added to demonstrate that there are 3 different colors for this-->
                                <div class="<%= "cb-title " + (index == 0 ? "green-back" : (index < 3 ? "blue-back" : "dark-back" ))%> ">
                                    <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />

                                </div>
                                <div class="overall-suitablity">
                                    <div class="<%= "over-all " + (index == 0 ? "f-60 green" : (index < 3 ? "blue"  : "gray"))%> ">
                                        <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="Integer" />
                                    </div>
                                    <div class="overall">overall suitablity</div>
                                </div>
                                <div class="jcc-box">
                                    <div class="job-match jcc">
                                        <img src="images/app-job-match-icon.svg"> job match 
                                        <span>
                                            <oneit:toString value="<%= jobApplication.getJobMatchPercentage() %>"   mode="PercentageWholeNumber" />
                                        </span>
                                    </div>
                                    <div class="culture jcc">
                                        <img src="images/culture-icon.svg"> culture
                                        <span>
                                            <oneit:toString value="<%= jobApplication.getCulturePercentage() %>"    mode="PercentageWholeNumber" />
                                        </span>
                                    </div>
                                    <div class="criteria jcc">
                                        <img src="images/criteria-icon.svg"> criteria
                                        <span>
                                            <oneit:toString value="<%= jobApplication.getCriteriaPercentage() %>"   mode="PercentageWholeNumber" />
                                        </span>
                                    </div>
                                </div>
                            </div>
                    <%
                            index++;
                        }
                    %>
                    <div class="app-border-bottom"></div>    
                </div>            
                <div class="main-expand-btn">
                    <div class="expand-btn">Expand shortlist <img src="images/arrow-white-icon.svg"></div>
                </div>
                <div class="app-line-br">
                    <span></span>
                </div>
                <div class="main-applicants-filter">
                    <div class="appli-list-shorting">
                        <div class="appli-shorting-dropdown appli-left">
                            <span class="appli-order-label">Bulk Update</span>
                            <select class="form-control">
                                <option>To Shortlist</option>
                            </select>
                        </div>         
                        <div class="appli-shorting-dropdown">
                            <span class="appli-order-label">order by</span>
                            <select class="form-control"    onChange="location=this.value">
                            <%
                                for (AppSortOption  sortOption : AppSortOption.getAppSortOptionArray())
                                {
                                    String  optionLink  =   applicationPage + "&JobID=" + job.getID() + "&AppSortOption=" + sortOption.getName() ;
                            %>
                                    <option <%= (appSortOpt != null && appSortOpt == sortOption ? "selected" : "" )%>  value="<%= optionLink %>">
                                        <oneit:toString value="<%= sortOption.getDescription() %>"   mode="EscapeHTML"/>
                                    </option>
                            <%
                                }
                            %>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="view-appli-list">
                <%
                    int j   = 0;

                    for(JobApplication jobApplication : sortedApplications)
                    {
                        String  jobMatch    =   FormatUtils.stringify(jobApplication.getJobMatchPercentage(), "PercentageWholeNumber", "0");
                        String  culture     =   FormatUtils.stringify(jobApplication.getCulturePercentage(), "PercentageWholeNumber", "0");
                        String  criteria    =   FormatUtils.stringify(jobApplication.getCriteriaPercentage(), "PercentageWholeNumber", "0");
                %>
                        <div class="appli-row">
                            <div class="appli-checkbox appli-l eq-second-height">
                                <div class="checkbox-list">
                                    <oneit:ormInput obj="<%= jobApplication %>" id="<%= jobApplication.getID().toString()%>"  attributeName="IsSelected"  type="checkbox"/>
                                    <oneit:recalcClass  htmlTag="span"  classScript="jobApplication.getIsSelected() != null && jobApplication.getIsSelected() ? 'checked': 'unchecked'" jobApplication="<%= jobApplication %>">
                                        <label for="<%= jobApplication.getID().toString()%>"/>
                                    </oneit:recalcClass>
                                </div>
                            </div>
                            <div class="appli-list-name appli-l eq-second-height">
                                <oneit:toString value="<%= jobApplication.getCandidate() %>"    mode="EscapeHTML" />
                                <div class="appli-int-status">Shortlisted</div>
                            </div>
                            <div class="appli-jcs appli-l eq-second-height">
                                <span class="appli-view-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= jobMatch %>" aria-valuemin="0" aria-valuemax="100" 
                                                style="<%= "width: " + jobMatch %>">
                                        </div>
                                    </div>
                                </span>
                                Job Match
                            </div>
                            <div class="appli-jcs appli-l eq-second-height">
                                <span class="appli-view-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= culture %>" aria-valuemin="0" aria-valuemax="100" 
                                                style="<%= "width: " + culture %>">
                                        </div>                                
                                    </div>
                                </span>
                                culture
                            </div>
                            <div class="appli-jcs appli-l eq-second-height">
                                <span class="appli-view-bar">
                                    <div class="progress">
                                        <div class="progress-bar" role="progressbar" aria-valuenow="<%= criteria %>" aria-valuemin="0" aria-valuemax="100" 
                                                style="<%= "width: " + criteria %>">
                                        </div>
                                    </div>
                                </span>
                                selection criteria
                            </div>
                            <div class="appli-status appli-l eq-second-height">
                                <!--TODO: logic needed to be worked out. Added to note that there are three colors-->
                                <div class="<%= "appli-percent-no " + (j == 0 ? "green" : (j < 3 ? "blue" : "grey" ))%>">
                                    <oneit:toString value="<%= jobApplication.getOverallSuitability() %>"   mode="Integer" />
                                </div>
                                <div class="appli-list-drop">
                                    <select class="form-control">
                                        <option>Interview</option>
                                    </select>
                                </div>
                            </div> 
                        </div>
                <%
                        j++;
                    }
                %>
                </div>
            </div>
        </div>
    </oneit:form>
</oneit:dynIncluded>