package performa.form;

import java.util.Map;
import oneit.logging.LogLevel;
import oneit.logging.LogMgr;
import oneit.objstore.StorageException;
import oneit.servlets.forms.SubmissionDetails;
import oneit.servlets.forms.SuccessfulResult;
import oneit.servlets.process.ORMProcessState;
import oneit.servlets.process.SaveFP;
import oneit.utils.BusinessException;
import performa.orm.Company;
import performa.orm.CompanyUser;
import javax.servlet.http.HttpServletRequest;


public class SaveCompanyUserFP extends SaveFP 
{
    @Override
    public SuccessfulResult processForm(ORMProcessState process, SubmissionDetails submission, Map params) throws BusinessException, StorageException
    {
        HttpServletRequest  request     =   submission.getRequest();
        CompanyUser         companyUser =   (CompanyUser) request.getAttribute("CompanyUser");
        Boolean             disabled    =   (Boolean) request.getAttribute("disabled");

        LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyUserFP saving company user : ", companyUser );

        companyUser.setIsDisabled(disabled);
        
        LogMgr.log(Company.LOG, LogLevel.PROCESSING1,"In SaveCompanyUserFP setting is disabled : ", disabled , " for company user : ",companyUser );
        
        return super.processForm(process, submission, params);
    }
}