package performa.orm;

import com.stripe.model.Card;
import com.stripe.model.Coupon;
import java.util.Date;
import java.util.Set;
import oneit.logging.LoggingArea;
import oneit.objstore.ValidationContext;
import oneit.objstore.rdbms.filters.EqualsFilter;
import oneit.utils.DateDiff;
import oneit.utils.StringUtils;
import oneit.utils.filter.Filter;
import oneit.utils.parsers.FieldException;
import performa.utils.StripeUtils;


public class HiringTeam extends BaseHiringTeam
{
    private static final long serialVersionUID = 0L;
    
    public  static LoggingArea  LOG = LoggingArea.createLoggingArea("HiringTeam");

    // This constructor should not be called
    public HiringTeam ()
    {
        // Do not add any code to this, always put it in initialiseNewObject
    }
    
    public boolean showHasClientSupport()
    {
        return isTrue(getHasClientSupport());
    }
    
    @Override
    public void validate(ValidationContext context) 
    {
//        if(getStatus() != ObjectStatus.NEW)
//        {
//            context.check(getHiringTeamType() != null , this, FIELD_HiringTeamType, "mandatory");
//        }
        
        super.validate(context);
    }
        
    @Override
    public String getToString() 
    {
        return StringUtils.subNulls(getHiringTeamName(), super.getToString());
    }
    
    public Set<CompanyUser> getActiveTeammates()
    {
        Filter<CompanyUser> filter  =   CompanyUser.SearchByAll()
                                                    .andIsAccountVerified(new EqualsFilter<>(Boolean.TRUE))
                                                    .andIsDisabled(new EqualsFilter<>(Boolean.FALSE));
        
        return CompanyUserHiringTeamLink.pipesCompanyUserHiringTeamLink(getUsersSet()).toCompanyUser(filter).uniqueVals();
    }
    
    public boolean isPPJ()
    {
        return isTrue(getIsPPJ());
    }
    
    public int getRemainingJobs()
    {
        return getPaymentPlan() != null && getPaymentPlan().getActiveJobCount() != null ? 
                    getPaymentPlan().getActiveJobCount() - getUsedCredits() : 0;
    }
    
    public Card getCard() throws FieldException
    {
       return StripeUtils.retrieveCard(this);
    }
    
    
    public String getCardNumber() throws FieldException
    {
        if(getStripeLast4() == null)
        {
            Card    card    =   StripeUtils.retrieveCard(this);
            
            if(card != null)
            {
                setStripeLast4(card.getLast4());
                setStripeBrand(card.getBrand());
                
                return "xxxx-xxxx-xxxx-" + getStripeLast4();
            }
            else
            {
                return "";
            }
        }
        
        return "xxxx-xxxx-xxxx-" + getStripeLast4();
    }
    
    
    public String getExpiry () throws FieldException
    {
        Card    card    =   StripeUtils.retrieveCard(this);

        return card != null ? String.format("%02d", card.getExpMonth()) + " / " + (card.getExpYear() % 100) : "";
    }

    @Override
    public Integer getUsedCredits() 
    {
        return super.getUsedCredits() != null ? super.getUsedCredits() : 0;
    }
    
    
    public boolean hasValidCoupon() throws FieldException
    {
        return hasValidCouponOn(DateDiff.getToday());
    }
    
    public boolean hasValidCouponOn(Date date) throws FieldException
    {
        if(getCoupon() != null)
        {
            Coupon coupon   =   StripeUtils.retrieveCoupon(getCoupon().getCouponCode());

            if(coupon.getValid() && (getCouponExpiryDate() == null  || date.before(getCouponExpiryDate())))
            {
                return true;
            }
        }
        
        setCoupon(null);
        setCouponExpiryDate(null);
        
        return false;
    }
}